% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/baQCA.R
\name{baQCA}
\alias{baQCA}
\title{Boostrapped Assessment}
\usage{
baQCA(mod, sim = 2000, include = c(""), row.dom = F, omit = c(),
  dir.exp = c())
}
\arguments{
\item{mod}{name of the QCA eqmcc model object.}

\item{sim}{the number of simulations the baQCA function should run. Default set to \code{sim=2000}.}

\item{include}{[from QCAGUI package] ``A vector of additional output function values to be included in the minimization.'' Default set to \code{include=c("")}.}

\item{row.dom}{[from QCAGUI package] ``Logical, impose row dominance as constraint on solution to eliminate dominated inessential prime implicants.'' Default set to \code{F}.}

\item{omit}{[from QCAGUI package] ``A vector of configuration index values or matrix of configurations to be omitted from minimization.'' Default set to \code{omit=c()}.}

\item{dir.exp}{[from QCAGUI package] ``A vector of directional expectations for deriving intermediate solutions.'' Default set to \code{dir.exp=c()}.}
}
\value{
After some time, this function returns the probability that the data will return a random result given the parameters set by the researcher in the model (configurational n threshold, consistency score threshold, etc), as well a confidence interval around this value. This value is interpreted similarly to a p-value, i.e. a .05 value coincides with a 95\% "confidence level."
}
\description{
This function performs the the Bootstrapped Assessment for QCA (baQCA) on a given QCA model object.
}
\examples{
data(rallies)
P<-rallies$P
R<-rallies$R
C<-rallies$C
U<-rallies$U

qca.data<-data.frame(P,R,C,U)
truth<-truthTable(qca.data,outcome="P",sort.by="incl",incl.cut1=0.7,show.cases=TRUE)
truth
mod1 <- eqmcc(truth,details=TRUE,show.cases=TRUE)
mod1

baQCA(mod1,sim=5)
}

