% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QCAdiff.R
\name{QCAdiff}
\alias{QCAdiff}
\title{QCA Case Difference}
\usage{
QCAdiff(x, y, show = FALSE)
}
\arguments{
\item{x}{name of one QCA model object.}

\item{y}{name of a second QCA model object.}

\item{show}{Logical, use to show the cases in the solution set for each QCA model object. Default set to \code{show=F}.}
}
\value{
Shows the cases excluded/removed from the final, more robust QCA model object.
}
\description{
Provides a data frame of all cases removed from the final QCA model object, after applying recommendations from brQCA.
}
\examples{
data(rallies)
P<-rallies$P
R<-rallies$R
C<-rallies$C
B<-rallies$B

qca.data<-data.frame(P,R,C,B)
rownames(qca.data)<-rownames(rallies)
truth<-truthTable(qca.data,outcome="P",sort.by="incl",incl.cut1=0.2,show.cases=TRUE,n.cut=1)
mod1<-minimize(truth,details=TRUE,show.cases=TRUE)
mod1

truth2<-truthTable(qca.data,outcome="P",sort.by="incl",incl.cut1=0.7,show.cases=TRUE,n.cut=3)
mod2<-minimize(truth2,details=TRUE,show.cases=TRUE)
mod2

QCAdiff(mod1,mod2,show=FALSE)
}
