% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/part_coeff.R
\name{part.coeff}
\alias{part.coeff}
\title{Calculate vertex participation coefficient}
\usage{
part.coeff(g, memb, use.parallel = TRUE)
}
\arguments{
\item{g}{The graph}

\item{memb}{The community membership indices of each vertex}

\item{use.parallel}{Logical indicating whether or not to use \emph{foreach}
(default: TRUE)}
}
\value{
A vector of the participation coeff's for each vertex of the graph.
}
\description{
This function calculates the participation coefficient of each vertex in a
graph, based on community membership.
}
\details{
The participation coefficient \eqn{P_i} of vertex \emph{i} is:
\deqn{P_i = 1 - \sum_{s=1}^{N_M} \left ( \frac{\kappa_{is}}{\kappa_i} \right )^2}
where \eqn{\kappa_{is}} is the number of edges from vertex \emph{i} to
vertices in module \emph{s}, and \eqn{\kappa_s} is the degree of vertex
\emph{i}. \eqn{N_M} equals the number of modules.

As discussed in Guimera et al., \eqn{P_i = 0} if vertex \emph{i} is connected
only to vertices in the same module, and \eqn{P_i = 1} if vertex \emph{i} is
equally connected to all other modules.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Guimera, R. and Amaral, L.A.N. (2005) Cartography of complex
networks: modules and universal roles, Journal of Statistical Mechanics:
Theory and Experiment, 02, P02001.
}

