% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/choose_edges.R
\name{choose.edges}
\alias{choose.edges}
\title{Select edges for re-wiring.}
\usage{
choose.edges(A, degs, degs.large)
}
\arguments{
\item{A}{Numeric (adjacency) matrix}

\item{degs}{Integer vector of the graph's degree sequence}

\item{degs.large}{Integer vector of vertex numbers with degree greater than
one}
}
\value{
A data frame with four elements; two edges will be removed and two
edges will be added between the four vertices.
}
\description{
This function selects edges to be re-wired when simulating random graphs. It
is based on the algorithm by Bansal et al. (2009), BMC Bioinformatics.
}
\references{
Bansal S., Khandelwal S., Meyers L.A. (2009) \emph{Exploring
biological network structure with clustered random networks}. BMC
Bioinformatics, 10:405-421.
}
\seealso{
\code{\link{sim.rand.graph.clust}}
}
