% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color_vertices_edges.R
\name{GraphColors}
\alias{GraphColors}
\alias{set_vertex_color}
\alias{set_edge_color}
\title{Color graph vertices and edges}
\usage{
set_vertex_color(memb)

set_edge_color(g, memb)
}
\arguments{
\item{memb}{An integer vector representing membership of e.g. a community}

\item{g}{An \code{igraph} graph object}
}
\value{
\code{set_vertex_color} - a character vector of colors with length
  equal to the number of vertex groups

\code{set_edge_color} - a character vector of colors with length
  equal to the edge count of \code{g}
}
\description{
\code{set_vertex_color} takes an integer vector (representing membership of
a community or component, etc.) and creates a character vector of colors for
each community/module, component, etc. This only assigns a color to groups
with at least 2 members; isolated vertices will be colored \emph{gray}.

\code{set_edge_color} additionally takes as input an \code{igraph} graph
object. It assigns to the edges a specific color (the same as the vertex
membership colors). Edges that connect vertices of two different groups are
colored gray.
}
