% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtpc.R
\name{plot.mtpc}
\alias{plot.mtpc}
\title{Plot statistics from an MTPC analysis}
\usage{
\method{plot}{mtpc}(x, contrast = 1, region = NULL,
  only.sig.regions = TRUE, show.null = TRUE, caption.stats = FALSE, ...)
}
\arguments{
\item{x}{A \code{mtpc} object}

\item{contrast}{Integer specifying which contrast to plot results for
(default: 1)}

\item{region}{Character string specifying which region's results to
plot; only relevant if \code{level='vertex'} (default: \code{NULL})}

\item{only.sig.regions}{Logical indicating whether to plot only significant
regions (default: \code{TRUE})}

\item{show.null}{Logical indicating whether to plot points of the maximum
null statistics (per permutation)}

\item{caption.stats}{Logical indicating whether to print the MTPC statistics
in the caption of the plot (default: \code{FALSE})}

\item{...}{Unused}
}
\value{
A list of \code{\link[ggplot2]{ggplot}} objects
}
\description{
Plot the statistics from an MTPC analysis, along with the maximum permuted
statistics. The output is similar to Figure 11 in Drakesmith et al. (2015).
}
\examples{
\dontrun{
mtpcPlots <- plot(mtpc.diffs)

## Arrange plots into 3x3 grids
ml <- marrangeGrob(mtpcPlots, nrow=3, ncol=3)
ggsave('mtpc.pdf', ml)
}
}
\references{
Drakesmith M, Caeyenberghs K, Dutt A, Lewis G, David AS, Jones
  DK (2015). \emph{Overcoming the effects of false positives and threshold
  bias in graph theoretical analyses of neuroimaging data.} NeuroImage,
  118:313-333.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
