% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rich_club.R
\name{rich_club_norm}
\alias{rich_club_norm}
\title{Calculate the normalized rich club coefficient}
\usage{
rich_club_norm(g, N = 100, rand = NULL, ...)
}
\arguments{
\item{g}{An \code{igraph} graph object}

\item{N}{Integer; the number of random graphs to generate (default: 100)}

\item{rand}{A list of \code{igraph} graph objects, if random graphs have
already been generated (default: NULL)}

\item{...}{Other parameters (passed to \code{\link{sim.rand.graph.par}})}
}
\value{
A data table with columns:
  \item{k}{Sequence of degrees}
  \item{rand}{Rich-club coefficients for the random graphs}
  \item{orig}{Rich-club coefficients for the original graph.}
  \item{norm}{Normalized rich-club coefficients.}
  \item{p}{The P-values based on the distribution of rich-club coefficients
    from the random graphs.}
  \item{p.fdr}{The FDR-adjusted P-values}
  \item{density}{The observed graph's density}
  \item{threshold,Group,name}{(if applicable)}
}
\description{
This function will (optionally) generate a number of random graphs, calculate
their rich club coefficients (\eqn{\phi}), and return \eqn{\phi} of the graph
of interest divided by the mean across random graphs, i.e. \eqn{\phi_{norm}}.
If random graphs have already been generated, you can supply a list as an
argument (since graph generation is time consuming).
}
\references{
Colizza V., Flammini A., Serrano M.A., Vespignani A. (2006)
\emph{Detecting rich-club ordering in complex networks}. Nature Physics,
2:110-115.
}
\seealso{
Other Rich-club functions: \code{\link{plot_rich_norm}},
  \code{\link{rich_club_attrs}},
  \code{\link{rich_club_coeff}}, \code{\link{rich_core}}

Other Random graph functions: \code{\link{RandomGraphs}},
  \code{\link{analysis_random_graphs}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
