% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_resid.R
\name{plot.brainGraph_resids}
\alias{plot.brainGraph_resids}
\title{Plot model residuals for each brain region}
\usage{
\method{plot}{brainGraph_resids}(x, regions = NULL, cols = FALSE, ...)
}
\arguments{
\item{x}{A \code{brainGraph_resids} object (from \code{\link{get.resid}})}

\item{regions}{Character vector of region(s) to focus on; default behavior is
to show summary for all regions}

\item{cols}{Logical indicating whether to color by group (default: FALSE)}

\item{...}{Unused}
}
\value{
A list of \code{\link[ggplot2]{ggplot}} objects
}
\description{
Check the model residuals for each brain region in a structural covariance
analysis. It shows a \emph{qqplot} of the studentized residuals, as output
from \code{\link{get.resid}}.
}
\examples{
\dontrun{
## First get the resid's and store the plots as an object
myresids <- get.resids(lhrh, covars)
p.resids <- plot(myresids, cols=TRUE)

## Open a new plot device for each set of 9
lapply(p.resids, function(x) {dev.new(); print(x)})

## Save as a multi-page PDF; requires \\code{gridExtra}
ml <- marrangeGrob(p.resids, nrow=1, ncol=1)
ggsave('residuals.pdf', ml)
}
}
\seealso{
\code{\link[stats]{qqnorm}}

Other Structural covariance network functions: \code{\link{IndividualContributions}},
  \code{\link{brainGraph_boot}},
  \code{\link{brainGraph_init}},
  \code{\link{brainGraph_permute}},
  \code{\link{corr.matrix}}, \code{\link{get.resid}},
  \code{\link{plot_volumetric}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
