% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_matrix.R
\name{Matrix utilities}
\alias{Matrix utilities}
\alias{colMax}
\alias{colMaxAbs}
\alias{colMin}
\alias{diag_sq}
\alias{get_thresholds}
\alias{is_binary}
\alias{qr.array}
\alias{qr_Q2}
\alias{qr_R2}
\alias{symm_mean}
\alias{symmetrize}
\alias{symmetrize.matrix}
\alias{symmetrize.array}
\title{Matrix/array utility functions}
\usage{
colMax(x, n = dim(x)[1L])

colMaxAbs(x, n = dim(x)[1L])

colMin(x, n = dim(x)[1L])

diag_sq(x, n = dim(x)[1L], inds = 1L + 0L:(n - 1L) * (n + 1L))

get_thresholds(x, densities, emax = dim(x)[1L] * (dim(x)[1L] - 1L)/2,
  ...)

is_binary(x)

\method{qr}{array}(x, ...)

qr_Q2(QR, y = diag(1, n, p), n = dim(QR$qr)[1L], p = QR$rank)

qr_R2(QR, p = QR$rank)

symm_mean(x)

symmetrize(x, ...)

\method{symmetrize}{matrix}(x, symm.by = c("max", "min", "avg"), ...)

\method{symmetrize}{array}(x, symm.by = c("max", "min", "avg"), ...)
}
\arguments{
\item{x}{Numeric matrix or array (the latter, for \code{qr.array} and
\code{symmetrize.array})}

\item{n, p}{Integer; the number of rows or rank (respectively) of
the input matrix or QR decomposition}

\item{inds}{Vector-based indices of the diagonal}

\item{densities}{Numeric vector of densities}

\item{emax}{Integer; the maximum number of edges}

\item{...}{Arguments passed to either \code{\link{sort}} (for
\code{get_thresholds}) or \code{\link{qr.default}} (for \code{qr.array}).
For the former, this will typically only be \code{decreasing=TRUE}, if that
is the desired behavior}

\item{QR}{A \code{qr} object}

\item{y}{A numeric matrix with \code{1} along the diagonal, of the same size
as the input matrix (i.e., \code{QR$qr})}

\item{symm.by}{Character string; how to create symmetric off-diagonal
elements. Default: \code{max}}
}
\value{
\code{diag_sq} returns an unnamed numeric vector with the values
  along the diagonal of the input matrix

\code{get_thresholds} returns a numeric vector of the thresholds

\code{is_binary} returns a logical of length 1

\code{qr.array} returns a \emph{list} in which each element is the QR
  decomposition of each matrix along \code{x}'s 3rd dimension
}
\description{
These functions are utility/helper functions when working with matrices or
arrays.

\code{diag_sq} is a pared-down version of \code{\link{diag}} for square
matrices. It does not return any dimnames, does not check if \code{x} is a
square matrix, and it cannot be used to \emph{create} a matrix with a given
value along the diagonal. Meant to be used in code that is called repeatedly
(thousands of times).

\code{get_thresholds} calculates the threshold values that would result in a
specific graph density. These depend, necessarily on the values in the matrix
themselves.

\code{qr.array} will calculate the QR decomposition for each matrix in a 3D
array.

\code{qr_Q2} and \code{qr_R2} are simplified versions of \code{\link{qr.Q}}
and \code{\link{qr.R}}.

\code{symm_mean} returns a symmetric matrix in which the off-diagonal
elements \eqn{A[i, j]} and \eqn{A[j, i]} are set to the mean of the values
in the input matrix.

\code{symmetrize} will symmetrize a numeric matrix (or each matrix in an
array) by assigning to the off-diagonal elements either the \code{max}
(default), \code{min}, or \code{average} of \eqn{\{A(i, j), A(j, i)\}}.
}
\details{
Given a vector of densities, \code{get_thresholds} returns the numeric values
that will result in graphs of the given densities after thresholding by those
values. In the \emph{Examples} section, the thresholds should result in
graphs with densities of \eqn{5, 15, \dots, 55} percent.
}
\examples{
x <- matrix(runif(25 * 25), 25, 25)
x <- symmetrize(x)
diag(x) <- 0
densities <- seq(0.05, 0.55, by=0.1)
threshes <- get_thresholds(x, densities)
## Verify that the densities are correct
graphs <- lapply(threshes, function(th) {
  graph_from_adjacency_matrix(x * (x > th), mode='undirected',
                              diag=FALSE, weighted=TRUE)
  })
sapply(graphs, graph.density)
}
