context("vignettes")
library(breakaway)

test_that("the vignettes say the correct thing", {
  skip_on_cran()
  data("toy_otu_table")

  ## breakaway.Rmd
  ba2 <- toy_otu_table[,2] %>% make_frequency_count_table %>% breakaway
  expect_is(ba2$other$full, "lm")
  expect_true(ba2$model == "Negative Binomial")

  ## diversity intro
  pasolli_et_al_num_samples <- c(2, 2, 1, 3, 11, 1, 7, 23, 1, 9, 4, 1, 1, 16, 2, 1, 2, 1, 9,
                     3, 94, 487, 1, 2, 1, 14, 2, 15, 67, 1, 2, 1, 2, 3, 1, 7, 2, 2,
                     2, 1, 1, 1, 2, 3, 78, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 5,
                     1, 2, 2, 2, 15, 1, 8, 8, 3, 2, 16, 10, 20, 1, 3, 3, 5, 192, 8,
                     6, 2, 7, 1, 1, 1, 9, 6, 7, 1, 4, 8, 35, 2, 17, 9, 1, 17, 4, 1,
                     75, 4, 31, 3, 10, 7, 10, 2, 22, 1, 1, 1, 1, 18, 7, 1, 1, 49,
                     15, 4, 40, 35, 15, 14, 1, 1, 1, 3, 14, 21, 13, 2, 66, 29, 1,
                     3, 171, 12, 41, 125, 1, 128, 19, 22, 4, 3, 2, 3, 2, 2, 1, 1,
                     11, 4, 22, 1, 24, 1, 1, 1, 3, 7, 19, 1, 1, 8, 15, 64, 5, 34,
                     14, 1, 33, 3, 2, 81, 2, 1, 14, 3, 28, 72, 1, 17, 1, 1, 2, 3,
                     2, 4, 1, 1, 169, 51, 6, 20, 31, 38, 10, 120, 4, 3, 5, 26, 3,
                     3, 2, 11, 3, 1, 58, 8, 37, 121, 8, 6, 1, 23, 8, 3, 7, 1, 1, 56,
                     5, 1, 1, 1, 4, 9, 316, 78, 33, 75, 1, 1, 1, 1, 1, 9, 27, 4, 1146,
                     1, 1, 2, 16, 44, 2, 10, 1, 11, 4, 140, 1, 2, 4, 1, 1, 1, 1, 5,
                     5, 1, 1, 131, 3, 1, 79, 38, 10, 1, 149, 31, 166, 1, 7, 8, 57,
                     26, 1, 4, 105, 183, 210, 242, 1, 24, 1, 10, 3, 5, 4, 1, 6, 1,
                     27, 462, 82, 1, 1, 62, 1, 4, 1, 3, 1, 3, 3, 1, 1, 6, 33, 41,
                     99, 45, 54, 3, 3, 5, 945, 22, 28, 1, 13, 4, 63, 564, 1, 1, 1,
                     2, 1, 1, 1, 1, 1, 5, 3, 2, 319, 2, 1844, 654, 1, 1, 1, 4, 2,
                     16, 36, 3, 24, 1, 2, 4, 3, 250, 883, 6, 92, 2, 2, 5, 2983, 1,
                     3, 13, 2, 234, 16, 82, 1, 6, 2, 1, 65, 2, 437, 1, 33, 28, 2,
                     79, 317, 59, 7, 2, 151, 1, 1, 5, 3, 487, 1, 1, 1, 1, 315, 3,
                     1, 2, 1, 3, 58, 1, 1, 41, 198, 4, 15, 323, 1, 7, 69, 2, 18, 6,
                     114, 2, 515, 1, 4, 42, 5, 7, 9, 9, 2, 2, 12, 1, 1, 1, 1, 49,
                     3, 41, 11, 1, 9, 2169, 2, 2, 3, 1, 4, 5, 35, 13, 3, 1, 5, 5,
                     1, 73, 1008, 1, 4, 2, 1, 3, 140, 2, 2, 2, 9, 6, 119, 7, 1432,
                     7, 1, 2, 4, 6, 1, 2, 13, 1, 4, 10, 7, 9, 6, 6, 11, 2, 2, 7, 7,
                     13, 1, 4, 31, 7, 18, 2, 161, 3, 5, 2, 45, 35, 16, 2, 4, 15, 6,
                     215, 3, 44, 1, 1, 14, 1, 14, 1, 1, 3, 4, 4, 1, 538, 4, 16, 4,
                     78, 1, 1, 2, 1, 2, 11, 12, 2, 2, 29, 7, 1, 3, 6, 2, 1, 1, 1,
                     1, 4, 1, 1, 1, 4, 2, 1, 1, 6, 3, 1, 1, 1, 1, 6, 7, 1, 48, 1,
                     15, 1, 13, 5, 1, 1, 3, 5, 12, 48, 36, 5, 1, 2, 1, 1, 8, 1, 3,
                     2, 1, 2, 1, 4, 25, 15, 1, 3, 2, 2, 3, 2, 2, 4, 9, 1, 1, 2, 5,
                     1, 7, 2, 1, 1, 3, 6, 1, 1, 3, 4, 1, 2, 3, 1, 1, 28, 14, 20, 2,
                     2, 2, 1, 109, 2, 38, 380, 5, 103, 96, 177, 48, 1, 1, 15, 32,
                     1, 8, 38, 2, 6, 358, 5, 3, 2, 346, 1, 2, 4, 16, 717, 20, 1, 2,
                     6, 1, 315, 2, 995, 68, 12, 2, 2, 1, 3, 58, 54, 181, 1, 8, 2559,
                     2, 42, 1, 9, 1, 106, 91, 2, 195, 1, 4, 18, 2, 118, 13, 1, 31,
                     1, 4, 4, 8, 2, 2, 2, 5, 77, 1, 26, 5, 21, 8, 56, 3, 2, 1, 1,
                     2, 6, 4, 8, 4, 2, 3, 3, 4, 20, 13, 1, 1, 1, 1, 1, 4, 68, 1, 1,
                     1, 1, 1, 1, 6, 1, 1, 3, 1, 1, 1, 1, 1, 1, 2, 9, 1, 25, 3, 1,
                     47, 1, 19, 1, 3, 4, 22, 1, 1, 2, 7, 1, 2, 1, 1, 10, 1, 7, 2,
                     3, 1, 3, 1, 1, 3, 2, 1, 11, 13, 2, 2, 1, 1, 1, 10, 1, 1, 4, 9,
                     1, 73, 2, 5, 39, 2, 1, 3, 4, 1, 362, 2, 1, 2, 1, 1, 1, 1, 1,
                     1, 1, 7, 4, 7, 2, 65, 1, 2, 46, 1, 3, 1, 1, 8, 1, 2, 80, 6, 26,
                     1, 3, 1, 2, 7, 1, 2, 56, 1, 2, 3, 1, 1, 8, 1, 1, 2, 2, 1, 3,
                     9, 2, 2, 3, 64, 1, 1, 1, 14, 53, 4, 12, 17, 16, 2, 5, 66, 6,
                     1, 7, 1, 1, 1, 11, 10, 2, 18, 1, 9, 1, 1, 3, 11, 4, 116, 1, 1,
                     2, 42, 14, 4, 2, 12, 1, 2, 1, 22, 1, 3, 1, 2, 1, 1, 2, 3, 1,
                     1, 6, 1, 1, 1, 2, 3, 1, 8, 1, 3, 1, 2, 2, 2, 14, 5, 57, 13, 82,
                     1, 1, 1, 5, 8, 1, 1, 4, 1, 1, 3, 1, 10, 5, 4, 1, 1, 6, 1, 4,
                     1, 1, 6, 4, 12, 3, 15, 1, 2, 8, 8, 1, 1, 1, 2, 45, 1, 11, 1,
                     10, 14, 5, 82, 10, 104, 1, 2, 3, 327, 24, 39, 77, 118, 799, 1,
                     3, 3, 1, 2, 17, 1, 31, 3, 2, 1, 2, 1, 14, 8, 17, 1, 1, 3, 272,
                     5, 1, 5, 3, 2, 1, 69, 5, 1512, 7, 1, 1, 1, 1, 655, 1, 1, 180,
                     43, 1, 1, 1, 224, 1, 2, 1, 2, 1925, 1, 50, 690, 1, 1, 3, 2, 9,
                     779, 2, 6, 1, 3, 1, 4, 9, 2, 15, 1, 33, 121, 1, 1, 1, 15, 9,
                     687, 421, 34, 8, 1, 2, 32, 1, 169, 1, 2, 2, 3, 6, 3, 1, 1, 1133,
                     45, 1, 2, 1, 5, 3, 131, 205, 868, 17, 15, 49, 140, 1, 1, 1, 3,
                     2, 2, 1, 1, 1, 1, 8, 29, 63, 40, 5, 1, 1, 1, 1, 7, 1, 1, 2, 16,
                     1, 1, 1, 1, 42, 22, 66, 180, 233, 61, 2, 342, 2, 1, 3, 1, 2,
                     1, 1, 11, 1, 1, 96, 75, 5, 4, 2, 1, 1, 1, 1, 17, 12, 13, 6, 1,
                     7, 2, 1, 53, 8, 14, 2, 49, 1, 1, 1, 1, 1, 2, 1, 1, 3, 43, 3,
                     70, 1, 1, 4, 1, 3, 1, 1, 1, 1, 1, 2, 1, 3, 12, 8, 1, 250, 33,
                     4, 1575, 10, 163, 1, 14, 1, 1, 19, 2, 2, 1, 1, 263, 3, 5, 2,
                     3, 305, 1, 2, 1, 1, 1, 7, 5, 34, 10, 47, 123, 1, 1, 1, 366, 81,
                     52, 477, 1, 1, 31, 136, 1, 1, 1, 1, 1, 1, 1, 2, 1, 2, 2, 1, 16,
                     8, 775, 1, 1, 4, 1, 51, 1, 2, 3, 1, 1, 1, 14, 2, 13, 3, 27, 30,
                     1, 1, 1, 3, 1, 14, 1, 1, 78, 683, 2, 1, 104, 52, 310, 2, 107,
                     69, 2, 6, 49, 173, 25, 1, 2, 2, 11, 102, 10, 6, 2, 3, 4, 1, 13,
                     1, 1, 3, 1, 1, 2, 3, 1, 4, 1, 2, 1, 1, 1, 69, 1, 15, 2, 49, 9,
                     444, 36, 1, 8, 1, 30, 54, 4, 93, 11, 279, 1, 3, 1, 2, 107, 6,
                     2, 7, 11, 1, 3, 2, 2, 1, 1, 1, 24, 53, 11, 1, 35, 22, 1, 447,
                     44, 1, 29, 141, 1, 1, 5, 6, 176, 7, 62, 23, 3, 1, 1, 33, 4, 2,
                     1, 11, 1, 2, 2, 1, 2, 2, 1, 18, 11, 6, 1, 7, 11, 75, 18, 1, 3,
                     34, 1, 1, 3, 32, 3, 3, 1, 1, 8, 5, 1, 1, 2, 7, 58, 61, 2, 2,
                     12, 34, 2, 1, 1, 192, 1, 6, 3, 391, 1, 133, 30, 1, 7, 2, 4, 35,
                     1, 1, 5, 2, 8, 1005, 1, 4, 1, 1, 1, 1, 1, 3, 4, 5, 83, 1, 1,
                     1, 1, 30, 113, 6, 256, 4, 1, 1805, 4, 1, 1, 6, 201, 10, 185,
                     1, 3, 2, 4, 42, 5, 46, 165, 1, 1, 1, 6, 1, 102, 1, 2, 1, 5, 7,
                     4, 2, 114, 804, 1, 1, 2, 1112, 1, 4, 4, 56, 24, 4, 12, 1584,
                     8, 44, 10, 3453, 1, 483, 13, 558, 15, 590, 1, 3, 1, 1, 7, 5,
                     59, 548, 1, 55, 1, 42, 10, 30, 10, 6, 1, 4, 199, 9, 1, 2, 1,
                     1, 33, 37, 9, 3, 4, 3, 547, 4, 11, 1, 1, 1, 1, 23, 28, 252, 9,
                     51, 1, 4, 14, 47, 24, 19, 186, 33, 1, 492, 217, 94, 30, 26, 2,
                     1030, 208, 282, 2, 2, 1629, 145, 1, 2, 354, 547, 317, 2, 47,
                     7, 4, 3, 2, 41, 8, 1, 1, 2, 929, 4, 8, 1, 105, 39, 854, 211,
                     9, 1, 567, 1, 2, 2, 2, 6, 16, 394, 77, 3, 44, 1, 1, 3, 1, 1,
                     2, 2, 40, 1, 1, 51, 1, 28, 59, 2, 5, 11, 15, 2, 2, 7, 87, 1,
                     1, 3, 1, 1, 3, 1, 8, 14, 3, 7, 2, 1, 2, 1, 1, 27, 3, 3, 1, 3,
                     1, 2, 1, 17, 2, 3, 11, 4, 2, 19, 4, 238, 2, 1, 15, 5, 24, 23,
                     22, 2, 11, 1, 9, 3, 1, 20, 3, 2, 2, 25, 1, 2, 2, 2, 2, 1, 2,
                     672, 2, 36, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 2, 2, 332, 2,
                     1, 3, 23, 3, 1061, 2, 2, 3, 2, 4, 1, 6, 11, 1, 145, 17, 4, 3,
                     5, 435, 5, 15, 125, 48, 1, 28, 1, 1, 779, 1, 1, 3, 30, 2, 1,
                     2, 1, 17, 18, 1, 28, 13, 8, 25, 16, 1, 7, 18, 227, 1, 1, 4, 74,
                     4, 1, 1, 8, 112, 7, 17, 1, 1, 1, 2, 1, 14, 1, 25, 2, 2, 34, 2,
                     1, 1, 1, 4, 2, 1, 5, 3, 5, 5, 1, 1, 2, 5, 104, 55, 1, 28, 1,
                     1, 1, 2, 3, 2, 66, 9, 7, 26, 1, 12, 3, 3, 2, 113, 1, 1, 1, 2,
                     25, 1, 2, 1, 15, 3, 3, 1, 3, 11, 1, 1, 1, 3, 2, 1, 2, 2, 2, 6,
                     1, 6, 114, 1, 1, 1, 4, 20, 28, 29, 1, 6, 1, 1, 1, 1, 19, 4, 1,
                     7, 44, 5, 6, 4, 5, 2, 1, 69, 8, 25, 1, 1, 1, 6, 2, 7, 1, 1, 1,
                     1, 2, 1, 30, 1, 9, 38, 5, 2, 2, 95, 1, 1, 11, 4, 1, 5, 21, 1,
                     1, 1, 11, 53, 6, 5, 1, 11, 8, 2, 38, 1, 2, 2, 2, 4, 1, 3, 4,
                     2, 7, 10, 2, 1, 2, 6, 4, 1, 9, 1, 3, 56, 6, 12, 10, 2, 257, 2,
                     1, 2, 1, 1, 1, 14, 1, 1, 6, 43, 14, 7, 11, 96, 1, 1, 3, 3, 2,
                     2, 4, 1, 1, 60, 1, 37, 217, 1, 128, 3, 110, 6, 1, 8, 1, 116,
                     3, 5, 34, 2, 1, 2, 1, 2, 1, 96, 37, 13, 5, 3, 6, 2, 2, 17, 1,
                     166, 1, 1, 3, 2, 1, 13, 36, 3, 2, 7, 1, 1, 3, 1, 1, 1, 2, 81,
                     6, 5, 2, 178, 1, 1, 4, 41, 10, 16, 35, 4, 1, 1, 1, 23, 1, 1,
                     1, 11, 1, 2, 96, 1, 1, 1, 1, 1, 5, 11, 1, 1, 2, 3, 1, 1, 4, 2,
                     2, 1, 5, 4, 5, 1, 1, 2, 1, 2, 6, 1, 5, 23, 10, 58, 1, 2, 2, 57,
                     1, 1, 1, 1, 1, 1, 1, 97, 2, 6, 1, 2, 1, 3, 6, 1, 19, 1, 7, 5,
                     4, 44, 1, 1, 3, 2, 41, 1, 14, 1, 2, 4, 1, 67, 5, 6, 1, 2, 96,
                     238, 1, 13, 5, 303, 1, 1, 2, 18, 2, 90, 82, 3, 1, 2, 17, 3, 72,
                     8, 1, 1, 2, 25, 19, 1, 3, 81, 48, 1, 104, 2, 2, 18, 3, 1, 32,
                     1, 1, 1, 10, 31, 1, 1, 2, 21, 7, 2, 95, 3, 13, 4, 2, 32, 1, 11,
                     2, 2, 33, 5, 1, 8, 2, 4, 11, 1, 8, 1, 1, 1, 9, 1, 3, 4, 1, 1,
                     3, 7, 1, 1, 2, 14, 111, 1, 2, 2, 1, 3, 154, 5, 1, 2, 4, 173,
                     1, 75, 70, 31, 2, 8, 10, 2, 12, 1, 2, 4, 2, 5, 5, 4, 12, 1, 4,
                     2, 1, 5, 1, 1, 1, 2, 1, 1, 8, 26, 1, 19, 4, 3, 10, 1, 1, 13,
                     1, 1, 1, 1, 1, 2, 2, 1, 1, 1, 2, 1, 1, 1, 2, 2, 2, 20, 1, 1,
                     4, 2, 1, 1, 1, 11, 2, 3, 2, 18, 1, 14, 1, 1, 3, 2, 6, 12, 6,
                     2, 3, 26, 1, 1, 1, 1, 16, 26, 1, 1, 1, 1, 3, 1, 4, 1, 1, 178,
                     1, 2, 13, 1, 116, 1, 9, 622, 2, 1, 1, 1, 1, 1, 1, 9, 4, 1, 38,
                     1, 2, 1, 1, 2, 161, 1, 347, 52, 9, 6, 1, 1, 4, 565, 14, 206,
                     1, 2, 20, 42, 2, 4, 13, 13, 8, 21, 1, 2, 2, 38, 23, 1, 57, 1,
                     1, 1, 5, 13, 3, 2, 29, 5, 24, 1, 8, 9, 1, 12, 28, 1, 1, 1, 19,
                     1, 1, 3, 1, 1, 2, 11, 17, 117, 1, 404, 1, 1, 1, 10, 5, 10, 1,
                     1, 1, 1, 153, 1, 1, 3, 81, 1, 1, 1, 5, 333, 1, 1, 1, 41, 4, 59,
                     3, 9, 11, 1, 1, 1, 22, 4, 10, 22, 15, 5, 9, 24, 1, 20, 1, 3,
                     145, 1, 1, 42, 1, 50, 3, 15, 1, 4, 7, 1, 16, 2, 9, 2, 4, 1, 28,
                     31, 1, 4, 1, 1, 1, 11, 1, 4, 1, 1, 2, 1, 1, 1, 1, 11, 21, 1,
                     4, 1, 1, 2, 11, 1, 1, 11, 1, 100, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 2, 1, 1, 3, 5, 1, 2, 1, 3, 5, 63, 2, 2, 32, 2, 10, 3, 101,
                     1, 1, 1, 3, 8, 11, 14, 1, 153, 10, 54, 15, 17, 2, 6, 12, 30,
                     1, 11, 243, 11, 1, 26, 4, 46, 1, 1, 217, 1, 2, 1, 1, 3, 46, 1,
                     37, 32, 1, 4, 12, 19, 1, 2, 1, 1, 1, 1, 1, 3, 4, 2, 1, 2, 1,
                     4, 2, 26, 1, 1, 1, 1, 1, 5, 8, 1, 5, 1, 8, 1, 1, 1, 1, 25, 1,
                     1, 3, 16, 1, 3, 1, 2, 2, 126, 1, 1, 1, 1, 1, 1, 5, 1, 2, 1, 7,
                     1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1,
                     3, 1, 1, 1, 2, 2, 1, 2, 30, 1, 1, 3, 1, 1, 2, 1, 1, 2, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 7, 1, 1, 5, 1, 1, 1, 1, 2, 2, 1,
                     1, 2, 2, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 2, 1, 1, 1, 1, 1, 1, 1,
                     1, 6, 2, 17, 19, 1, 8, 1, 1, 1, 1, 4, 1, 6, 2, 2, 31, 1, 6, 16,
                     1, 2, 127, 1, 3, 1, 1, 1, 1, 7, 9, 1, 2, 3, 7, 13, 1, 7, 1, 44,
                     1, 242, 3, 1, 12, 20, 1, 8, 4, 3, 17, 15, 3, 1, 1, 3, 16, 11,
                     9, 11, 1, 4, 13, 2, 3, 1, 1, 2, 89, 3, 2, 4, 11, 2, 4, 4, 3,
                     1, 1, 31, 1, 64, 71, 1, 1, 2, 2, 1, 1, 3, 1, 1, 71, 26, 18, 13,
                     3, 3, 6, 25, 3, 3, 1, 2, 29, 3, 1, 1, 1, 2, 4, 1, 1, 2, 10, 8,
                     6, 1, 1, 21, 26, 3, 27, 1, 2, 13, 41, 17, 6, 1, 1, 1, 2, 8, 28,
                     58, 6, 1200, 4, 245, 2, 8, 55, 14, 1, 45, 1, 2, 1, 2, 1, 1, 1,
                     1, 8, 1, 7, 4, 331, 1, 360, 1, 1, 1, 2, 3, 1, 37, 2, 31, 192,
                     217, 50, 2, 1, 3, 33, 3, 145, 145, 1, 584, 3, 1, 441, 2, 1, 16,
                     33, 1, 18, 16, 1, 13, 2, 44, 32, 6, 1, 6, 1, 15, 1, 2, 5, 28,
                     1, 1, 22, 2, 1, 6, 14, 3, 3, 17, 20, 1, 1, 1, 1, 2, 2, 227, 1,
                     1, 1, 2, 242, 2, 110, 7, 26, 12, 289, 204, 1, 1, 1, 3, 3, 1,
                     9, 7, 7, 3, 2, 8, 1, 2, 1, 6, 1, 3, 42, 1, 1, 1, 54, 1, 1, 7,
                     3, 1, 2, 2, 1, 3, 8, 1, 7, 1, 40, 33, 152, 2, 1, 2, 1, 1, 1,
                     1, 1, 6, 4, 9, 11, 41, 7, 46, 3, 1, 1, 8, 6, 9, 1, 1, 5, 34,
                     6, 1, 2, 4, 1, 1, 2, 1, 17, 1, 6, 1, 1, 2, 1, 11, 1, 3, 2, 40,
                     17, 1, 1, 1, 2, 2, 3, 1, 1, 2, 3, 1, 4, 2, 5, 2, 5, 9, 8, 128,
                     1, 1, 25, 1, 1, 1, 1, 1, 28, 2, 133, 1, 1, 1, 1, 1, 3, 1, 1,
                     1, 2, 1, 4, 9, 22, 2, 25, 1, 1, 3, 2, 14, 1, 4, 5, 4, 3, 2, 11,
                     1, 1, 1, 1, 10, 1, 2, 1, 1, 1, 5, 3, 1413, 1, 9, 2, 13, 6, 2,
                     4, 1, 14, 21, 206, 11, 1, 7, 25, 10, 7, 4, 39, 3, 2, 5, 3, 1,
                     19, 4, 2, 1, 1, 1, 4, 7, 11, 2, 1, 5, 1, 1, 1, 1, 1, 6, 4, 1,
                     2, 1, 1, 2, 3, 11, 1, 1, 1, 4, 1, 2, 2, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 2, 1, 6, 19, 49, 2, 3, 1, 2, 2, 1, 1, 2, 1, 2, 1, 6, 2,
                     1, 1, 1, 1, 1, 1, 1, 8, 1, 1, 1, 39, 1, 2, 1, 2, 2, 2, 50, 1,
                     1, 3, 1, 2, 2, 1, 11, 19, 1, 1, 4, 1, 1, 1, 10, 15, 3, 4, 10,
                     78, 1, 2, 3, 88, 2, 1, 4, 1, 4, 2, 1, 3, 2, 1, 19, 1, 11, 33,
                     1, 2, 9, 2, 3, 145, 1, 2, 273, 20, 7, 65, 15, 19, 25, 1, 2, 4,
                     3, 1, 6, 3, 4, 5, 4, 1, 31, 13, 53, 1, 7, 4, 3, 17, 52, 2, 20,
                     12, 1, 2, 1, 1, 2, 20, 7, 1, 7, 2, 5, 6, 3, 9, 24, 16, 2, 1,
                     2, 1, 2, 1, 2, 1, 1, 1, 1, 1, 1, 19, 5, 1, 1, 1, 1, 2, 4, 1,
                     1, 7, 1, 3, 1, 1, 1, 2, 11, 7, 2, 1, 2, 3, 1, 1, 2, 14, 1, 1,
                     1, 1, 13, 14, 24, 6, 7, 17, 1, 2, 1, 2, 2, 3, 1, 14, 8, 1, 3,
                     13, 37, 12, 1, 4, 174, 1, 3, 1, 23, 2, 3, 1, 1, 1, 1, 1, 1, 32,
                     17, 7, 8, 1, 1, 2, 5, 13, 15, 1, 3, 2, 1, 8, 1, 3, 2, 4, 13,
                     1, 1, 15, 1, 1, 4, 3, 1, 46, 2, 1, 3, 3, 6, 4, 1, 3, 3, 2, 33,
                     1, 8, 124, 5, 6, 9, 1, 2, 21, 13, 1, 2, 1, 2, 2, 16, 9, 3, 1,
                     9, 2, 7, 67, 2, 16, 1, 14, 2, 75, 49, 1, 43, 2, 40, 2, 1, 2,
                     35, 23, 1, 69, 1, 5, 25, 2, 4, 5, 1, 1, 5, 1, 4, 79, 7, 1, 2,
                     1, 1, 44, 24, 3, 2, 6, 13, 7, 21, 2, 2, 629, 21, 5, 1, 492, 4,
                     351, 1, 3, 5, 72, 3, 22, 184, 1, 1, 10, 2, 1, 7, 5, 5, 3, 5,
                     2, 51, 1, 17, 1, 1, 4, 3, 102, 13, 5, 1, 1, 1, 1, 8, 2, 2, 2,
                     1, 3, 1, 1, 2, 5, 1, 44, 13, 9, 3, 4, 1, 2, 31, 8, 1, 1, 1, 26,
                     1, 11, 1, 20, 7, 16, 9, 1, 1, 1, 1, 2, 6, 10, 1, 1, 1, 5, 1,
                     1, 1, 1, 5, 1, 1, 2, 4, 2, 1, 1, 9, 29, 2, 12, 2, 8, 1, 1, 1,
                     1, 1, 1, 2, 2, 3, 1, 1, 58, 1, 1, 1, 1, 1, 1, 1, 1, 1, 4, 1,
                     2, 83, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 1, 3, 5, 1, 1, 1, 1, 13,
                     1, 2, 1, 4, 1, 2, 41, 3, 7, 2, 4, 4, 1, 2, 153, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2,
                     7, 3, 4, 13, 1, 1, 1, 1, 18, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 3, 2, 1, 2, 2, 1, 1, 1, 2, 1, 1, 2, 1, 7, 1, 1,
                     1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 6, 1, 2, 1, 2, 12, 3, 2, 2,
                     1, 1, 1, 2, 7, 1, 1, 1, 3, 2, 2, 1, 4, 2, 1, 1, 2, 3, 1, 2, 11,
                     2, 2, 2, 3, 1, 6, 2, 2, 3, 4, 3, 8, 859, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 19, 2, 8, 3, 55, 1, 1,
                     1, 1, 1, 1, 31, 1, 1, 1, 3, 2, 1, 1, 5, 1, 2, 6, 4, 1, 52, 1,
                     1, 126, 2, 6, 4, 2, 1, 1, 1, 7, 1, 1, 6, 1, 3, 2, 4, 3, 1, 110,
                     19, 1, 1, 1, 2, 2, 4, 3, 5, 103, 1, 2, 1, 3, 7, 57, 1, 4, 9,
                     13, 32, 1, 5, 1, 1, 1, 8, 17, 2, 1, 4, 2, 1, 1, 1, 3, 2, 27,
                     8, 1, 2, 2, 3, 1, 3, 4, 111, 1, 5, 2, 14, 1, 1, 1, 446, 4, 3,
                     2, 2, 2, 2, 1, 2, 7, 132, 3, 1, 1, 1, 4, 1, 1, 4, 1, 1, 6, 3,
                     8, 16, 1, 2, 3, 9, 1, 1, 1, 6, 23, 48, 1, 19, 132, 1, 2, 52,
                     7, 11, 10, 48, 2, 12, 1, 7, 5, 1, 17, 2, 1, 2, 1, 21, 2, 1, 1,
                     1, 3, 5, 1, 1, 5, 7, 4, 1, 4, 3, 10, 25, 1, 2, 5, 1, 6, 1, 1,
                     5, 2, 10, 2, 2, 3, 4, 1, 1, 2, 7, 2, 1, 40, 1, 6, 1, 3, 1, 2,
                     20, 138, 16, 314, 1, 1, 2, 1, 1, 6, 2, 1, 3, 1, 6, 1, 2, 13,
                     8, 3, 16, 11, 2, 2, 56, 1, 21, 1, 43, 2, 352, 1, 39, 1, 1, 3,
                     5, 26, 6, 1, 1, 2, 1, 1, 1, 32, 6, 6, 2, 430, 1, 2, 4, 1, 2,
                     5, 4, 2, 3, 2, 1, 1, 1, 4, 7, 2, 9, 1, 2, 244, 1, 1, 24, 2, 33,
                     34, 2, 102, 1, 341, 286, 423, 137, 3, 70, 1, 49, 4, 12, 12, 18,
                     31, 93, 3, 724, 110, 19, 8, 1, 3, 1, 1, 3, 2, 1, 62, 76, 36,
                     1, 4, 6, 3, 16, 8, 1, 1, 1, 11, 286, 1, 7, 1, 1, 10, 2, 17, 12,
                     2, 21, 2, 1, 2, 1, 53, 1, 8, 2, 6, 55, 1, 5, 2, 1, 1, 1, 2, 4,
                     7, 39, 2, 1, 1, 3, 9, 1, 36, 301, 1, 1, 1, 2, 16, 1, 4, 6, 52,
                     4, 148, 1, 32, 5, 35, 10, 1, 1, 1, 1, 2, 3, 8, 6, 26, 1, 1, 243,
                     2, 11, 1, 4, 1, 1, 2, 74, 34, 1, 1, 15, 2, 105, 292, 1, 157,
                     1, 44, 14, 2, 2, 3, 252, 1, 1, 1, 370, 4, 16, 2, 1188, 86, 3,
                     1, 1, 242, 1, 1, 2, 577, 61, 184, 1, 1, 340, 43, 18, 1, 9, 8,
                     1, 3, 13, 1811, 7, 2, 1, 2, 137, 9, 1, 1, 99, 1, 2, 99, 1212,
                     1, 2, 1, 1, 1, 1, 4, 6, 27, 132, 1513, 118, 720, 1, 8, 162, 185,
                     6, 3, 162, 1, 1, 21, 1, 2, 722, 113, 1, 1, 1, 1, 1, 44, 73, 1,
                     682, 1, 1, 4, 262, 1, 1, 3, 26, 4, 16, 2, 64, 454, 2, 1152, 10,
                     1, 1, 24, 137, 1, 71, 1, 1, 2, 1, 19, 1, 4, 30, 4, 2, 1, 5, 69,
                     1, 1, 1, 10, 16, 1, 1, 1, 1, 1, 9, 1, 1, 1, 1, 18, 2, 1, 2, 8,
                     8, 91, 2, 2, 3, 12, 471, 1, 1, 1, 1, 1, 1, 3, 12, 2, 5, 7, 1,
                     31, 6, 190, 10, 21, 1, 1, 8, 2, 12, 1, 3, 1, 1, 2, 1, 17, 5,
                     1, 1, 1, 5, 4, 3, 14, 5, 7, 11, 1, 1, 1, 1, 4, 1, 4, 7, 14, 18,
                     5, 1, 3, 4, 41, 1, 1, 3, 1, 1, 2, 3, 2, 1, 6, 54, 2, 4, 23, 19,
                     14, 6, 1, 1, 1, 3, 6, 1, 2, 1, 1, 2, 2, 1, 2, 1, 1, 1, 2, 1,
                     1, 1, 1, 3, 1, 1, 3, 18, 1, 6, 18, 5, 246, 9, 47, 3, 1, 1, 2,
                     3, 1, 2, 1, 1, 1, 1, 3, 1, 2, 2, 20, 130, 1, 1, 1, 1, 1, 1, 1,
                     1, 1, 25, 42, 89, 123, 2, 1, 1, 1, 3, 3, 1, 7, 111, 89, 8, 2,
                     2, 1, 5, 2, 1, 3, 3, 1, 2, 1, 1, 1, 1, 2, 7, 1, 1, 1, 2, 2, 8,
                     1, 1, 1, 1, 1, 1, 1, 4, 1, 3, 13, 1, 10, 10, 1, 5, 1, 4, 1, 1,
                     2, 1, 2, 1, 3, 3, 3, 4, 1, 1, 1, 140, 14, 8, 1, 2, 2, 52, 1,
                     1, 1, 1, 3, 1, 3, 1, 2, 4, 1, 4, 2, 4, 4, 2, 1, 7, 10, 2, 1,
                     11, 8, 4, 2, 1, 1, 33, 13, 15, 1, 2, 1, 1, 1, 1, 3, 9, 6, 1,
                     1, 1, 1, 1, 1, 2, 1, 2, 40, 1, 44, 459, 1, 8, 144, 4, 1248, 1,
                     1, 128, 1235, 59, 481, 5, 6, 1, 1, 62, 3, 1, 4, 7, 2, 22, 4,
                     3, 9, 8, 1, 1, 1, 14, 10, 23, 33, 1, 1, 2, 3, 1, 2, 1, 1, 2,
                     1, 2, 8, 1, 1, 3, 2, 17, 1, 5, 2, 2, 1, 4, 2, 2, 1, 2, 1, 1,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 8, 5, 2, 4, 2, 5, 1, 1, 2, 12, 2,
                     2, 1, 1, 1, 2, 1, 1, 1, 1, 2, 5, 2, 4, 3, 9, 4, 2, 1, 4, 3, 3,
                     2, 2, 2, 121, 1, 1, 1, 1, 1, 2, 1, 1, 1, 1, 2, 1, 1, 18, 1, 13,
                     1, 1, 8, 2, 13, 1, 1, 6, 1, 3, 1, 5, 23, 64, 1, 1, 1, 1, 1, 2,
                     1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 14,
                     1, 1, 1, 1, 1, 1, 1, 3, 8, 5, 1, 1, 1, 5, 2, 7, 1, 1, 1, 1, 1,
                     5, 7, 2, 34, 1, 8, 6, 12, 1, 2, 5, 2, 2, 5, 1, 1, 3, 1, 2, 2,
                     2, 1, 1, 1, 6, 7, 4, 1, 2, 3, 20, 2, 2, 1, 1, 1, 1, 1, 1, 2,
                     11, 1, 2, 5, 1, 2, 1, 1, 2, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
                     53, 3, 2, 35, 1, 1, 2, 1, 1, 2, 2, 2, 2, 5, 3, 3, 1, 1, 1, 1,
                     1, 4, 2, 4, 1, 2, 1, 1, 1, 1, 1, 1, 1, 12)

  ft <- pasolli_et_al_num_samples %>% make_frequency_count_table
  expect_true(ft[1,1] == 1)
  expect_true(ft[1,2] == 1972)
  expect_true(ft %>% sample_richness %$% estimate == 4930)
  expect_true(ft %>% breakaway %$% estimate %>% round == 7724)
})

