% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot.breakfast.cpts}
\alias{plot.breakfast.cpts}
\title{Change-points estimated by the "breakfast" routine}
\usage{
\method{plot}{breakfast.cpts}(x, display.data = TRUE, ...)
}
\arguments{
\item{x}{a \code{breakfast.cpts} object}

\item{display.data}{if \code{display.data = TRUE}, change-point estimators are plotted against the data by method.
If \code{display.data = FALSE}, only the estimators are plotted; this option is recommended when \code{length(x)} is large.}

\item{...}{current not in use}
}
\description{
Plot method for objects of class \code{breakfast.cpts}
}
\examples{
f <- rep(rep(c(0, 1), each = 50), 5)
x <- f + rnorm(length(f)) * .5
plot(breakfast(x, solution.path = 'all', model.selection = 'all'), display.data = TRUE)
plot(breakfast(x), display.data = FALSE)
}
