% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_breathtestfit.R
\name{plot.breathtestfit}
\alias{plot.breathtestfit}
\title{S3 plot method for breathtestfit}
\usage{
\method{plot}{breathtestfit}(x, inc = 5, method_t50 = "maes_ghoos", ...)
}
\arguments{
\item{x}{object of class \code{breathtestfit}, as returned by \code{\link{nls_fit}}, 
\code{\link{nlme_fit}}, \code{\link{null_fit}} or \code{stan_fit}; stan_fit is
in package \code{breathteststan},}

\item{inc}{Increment for fitted curve plot in minutes}

\item{method_t50}{Method for t50: "\code{maes_ghoos}", "\code{bluck_coward}" or 
"\code{maes_ghoos_scint}"}

\item{...}{other parameters passed to methods. Not used}
}
\description{
Plots 13C data and fits.
}
\details{
A description of plotting
}
\examples{
data = list(
  A = simulate_breathtest_data(n_records = 6, seed = 100)$data,
  B = simulate_breathtest_data(n_records = 4, seed = 187)$data 
)
# cleanup_data combines the list into a data frame
x = nls_fit(cleanup_data(data))
plot(x)
}
