% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef_diff_by_group.R
\name{coef_diff_by_group}
\alias{coef_diff_by_group}
\alias{coef_diff_by_group.breathteststangroupfit}
\title{Tabulates breath test parameter differences of groups from Stan group fit}
\usage{
coef_diff_by_group.breathteststangroupfit(fit, mcp_group = NULL,
  reference_group = NULL, ...)
}
\arguments{
\item{fit}{Object of class \code{breathteststangroupfit} from \code{\link[breathteststan]{stan_fit}}}

\item{mcp_group}{Not used, always all pairs are compared}

\item{reference_group}{Not used}

\item{...}{Not used}
}
\value{
A \code{tibble} of class \code{coef_diff_by_group_stan} with columns
\describe{
  \item{parameter}{Parameter of fit, e.g. \code{beta, k, m, t50}}
  \item{method}{Method used to compute parameter. \code{exp_beta} refers to primary
  fit parameters \code{beta, k, m}.}
  \item{groups}{Which pairwise difference, e.g \code{solid - liquid}}
  \item{estimate}{Point estimate (chain mean) of the difference}
  \item{cred.low, cred.high}{Lower and upper 95 percent credible interval of difference.}
}
The chains of pairwise differences  are returned as a attribute \code{chain}
for use in plotting. See example below how to use these to display difference histograms.
}
\description{
Given a Stan fit with grouping to 13C breath test curves,
computes point estimated and Bayesian credible intervals for all group pair
differences, for examples of the half emptying time \code{t50}.
}
\examples{
\donttest{
library(dplyr)
library(breathtestcore)
data("usz_13c", package = "breathtestcore")
data = usz_13c \%>\%
  dplyr::filter( patient_id \%in\%
    c("norm_001", "norm_002", "norm_003", "norm_004", "pat_001", "pat_002","pat_003")) \%>\%
  cleanup_data()
fit = stan_group_fit(data, iter = 300, chains = 1) # Use more iterations!
cf = coef_diff_by_group(fit)
cc = attr(cf, "chain") \%>\%
   filter(key == "t50_maes_ghoos", abs(diff) < 200) \%>\%
   mutate(
     groups = paste(group2, group1, sep = " - ")
   )
str(cc)
if (require(ggplot2)) {
  ggplot(cc, aes(x = diff)) + geom_histogram() + facet_wrap(~groups)
}
# For comparison
fit = nlme_fit(data)
coef_diff_by_group(fit)
}
}
