% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/07-diagnostics.R
\name{br_diagnose}
\alias{br_diagnose}
\title{Diagnose regression models}
\usage{
br_diagnose(breg, idx = NULL, transform = "km", ...)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Index or name (focal variable) of the model(s) to diagnose. If \code{NULL},
diagnoses all models in the breg object.}

\item{transform}{Character string specifying how to transform time for Cox PH tests.
Options are "km" (Kaplan-Meier), "rank", "identity", or a function.}

\item{...}{Additional arguments passed to specific diagnostic functions.}
}
\value{
A list containing diagnostic results for each model.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Universal diagnostic function that performs appropriate diagnostics based on
the model type. For Cox models, tests proportional hazards assumption using
Schoenfeld residuals and provides comprehensive Cox diagnostics.
For other models, provides general diagnostic information.
}
\examples{
# Create models
mds <- br_pipeline(
  survival::lung,
  y = c("time", "status"),
  x = colnames(survival::lung)[6:10],
  x2 = c("age", "sex"),
  method = "coxph"
)

# Diagnose models (includes PH testing for Cox models)
diagnostics <- br_diagnose(mds)
print(diagnostics)
}
\seealso{
Other accessors: 
\code{\link{accessors}},
\code{\link{br_predict}()}
}
\concept{accessors}
