% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04-show.R
\name{br_show_coxph_diagnostics}
\alias{br_show_coxph_diagnostics}
\title{Show Cox proportional hazards model diagnostic plots}
\usage{
br_show_coxph_diagnostics(
  breg,
  idx = 1,
  type = "schoenfeld",
  resid = TRUE,
  se = TRUE,
  point_col = "red",
  point_size = 1,
  point_alpha = 0.6,
  ...
)
}
\arguments{
\item{breg}{A regression object with results (must pass \code{assert_breg_obj_with_results()}).}

\item{idx}{Index or name (focal variable) of the Cox model to plot. Must be a single model.}

\item{type}{Type of Cox diagnostic plot. Options: "schoenfeld" (default for Schoenfeld residuals),
"martingale" (martingale residuals), "deviance" (deviance residuals).}

\item{resid}{Logical, if TRUE the residuals are included on the plot along with smooth fit.}

\item{se}{Logical, if TRUE confidence bands at two standard errors will be added.}

\item{point_col}{Color for residual points.}

\item{point_size}{Size for residual points.}

\item{point_alpha}{Alpha (transparency) for residual points.}

\item{...}{Additional arguments passed to \link[survival:cox.zph]{survival::cox.zph}.}
}
\value{
A ggplot2 object or list of plots.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates diagnostic plots specifically for Cox regression models.
Focuses on Schoenfeld residuals plots to assess proportional hazards assumption
and other Cox-specific diagnostics. Inspired by \href{https://search.r-project.org/CRAN/refmans/survminer/html/ggcoxzph.html}{survminer::ggcoxzph} with
enhanced visualization and computation optimizations to work in \strong{bregr}.
}
\examples{
# Create Cox models
mds <- br_pipeline(
  survival::lung,
  y = c("time", "status"),
  x = colnames(survival::lung)[6:10],
  x2 = c("age", "sex"),
  method = "coxph"
)

# Show Cox diagnostic plots
p1 <- br_show_coxph_diagnostics(mds, idx = 1)
p1
p2 <- br_show_coxph_diagnostics(mds, type = "martingale")
p2

}
\seealso{
Other br_show: 
\code{\link{br_show_fitted_line}()},
\code{\link{br_show_fitted_line_2d}()},
\code{\link{br_show_forest}()},
\code{\link{br_show_forest_circle}()},
\code{\link{br_show_forest_ggstats}()},
\code{\link{br_show_forest_ggstatsplot}()},
\code{\link{br_show_nomogram}()},
\code{\link{br_show_residuals}()},
\code{\link{br_show_risk_network}()},
\code{\link{br_show_survival_curves}()},
\code{\link{br_show_table}()},
\code{\link{br_show_table_gt}()}
}
\concept{br_show}
