% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bricks-from-mosaic.R
\name{bricks_from_mosaic}
\alias{bricks_from_mosaic}
\title{Convert a 2D LEGO mosaic into a 'brickr' 3D object}
\usage{
bricks_from_mosaic(mosaic_list, mosaic_height = 6, highest_el = "light")
}
\arguments{
\item{mosaic_list}{List output from image_to_bricks(). Contains an element \code{Img_lego}.}

\item{mosaic_height}{Number of layers in the 3D image.}

\item{highest_el}{Brick height is determined by brightness of color. Use \code{highest_el = 'dark'} for darkest bricks to have \code{mosaic_height}.}
}
\value{
A list with elements \code{Img_lego} to pass to \code{\link{build_bricks}}.
}
\description{
Stacks LEGO plates to create a 3D version of the 2D brick mosaics.
Height of bricks determined by brightness of color.
}
\examples{
# Import a jpeg or png
 demo_file <- system.file("extdata", "demo_img.jpg", 
                          package = "brickr", mustWork = TRUE)
 demo_image <- jpeg::readJPEG(demo_file)
 
 #Begin with a 24x24 mosaic object
 \donttest{
 mosaic <- demo_image \%>\% 
    image_to_mosaic(24)
    }
 
 #Pass the mosaic object to bricks_from_mosaic() to convert to 3D specifications
 \donttest{
 mosaic \%>\% 
   bricks_from_mosaic() \%>\% 
   build_bricks()
   
   rgl::clear3d()
   }
   
 #In this image, the background is a light color.
 # Change the 'highest_el' to make dark colors highest
 # Change mosaic height to change the number of layers
 \donttest{
 mosaic \%>\% 
   bricks_from_mosaic(mosaic_height = 3, highest_el = "dark") \%>\% 
   build_bricks()
 
  rgl::clear3d()
  }
}
\seealso{
Other 3D Models: 
\code{\link{bricks_from_coords}()},
\code{\link{bricks_from_excel}()},
\code{\link{bricks_from_table}()},
\code{\link{build_bricks}()}
}
\concept{3D Models}
