% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sql-query-execution.R
\name{db_sql_exec_query}
\alias{db_sql_exec_query}
\title{Execute SQL Query}
\usage{
db_sql_exec_query(
  statement,
  warehouse_id,
  catalog = NULL,
  schema = NULL,
  parameters = NULL,
  row_limit = NULL,
  byte_limit = NULL,
  disposition = c("INLINE", "EXTERNAL_LINKS"),
  format = c("JSON_ARRAY", "ARROW_STREAM", "CSV"),
  wait_timeout = "10s",
  on_wait_timeout = c("CONTINUE", "CANCEL"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{statement}{String, the SQL statement to execute. The statement can
optionally be parameterized, see \code{parameters}.}

\item{warehouse_id}{String, ID of warehouse upon which to execute a statement.}

\item{catalog}{String, sets default catalog for statement execution, similar
to \verb{USE CATALOG} in SQL.}

\item{schema}{String, sets default schema for statement execution, similar
to \verb{USE SCHEMA} in SQL.}

\item{parameters}{List of Named Lists, parameters to pass into a SQL
statement containing parameter markers.

A parameter consists of a name, a value, and \emph{optionally} a type.
To represent a \code{NULL} value, the value field may be omitted or set to \code{NULL}
explicitly.

See \href{https://docs.databricks.com/api/workspace/statementexecution/executestatement}{docs}
for more details.}

\item{row_limit}{Integer, applies the given row limit to the statement's
result set, but unlike the \code{LIMIT} clause in SQL, it also sets the
\code{truncated} field in the response to indicate whether the result was trimmed
due to the limit or not.}

\item{byte_limit}{Integer, applies the given byte limit to the statement's
result size. Byte counts are based on internal data representations and
might not match the final size in the requested format. If the result was
truncated due to the byte limit, then \code{truncated} in the response is set to
true. When using \code{EXTERNAL_LINKS} disposition, a default byte_limit of
100 GiB is applied if \code{byte_limit} is not explicitly set.}

\item{disposition}{One of \code{"INLINE"} (default) or \code{"EXTERNAL_LINKS"}. See
\href{https://docs.databricks.com/api/workspace/statementexecution/executestatement}{docs}
for details.}

\item{format}{One of \code{"JSON_ARRAY"} (default), \code{"ARROW_STREAM"}, or \code{"CSV"}.
See \href{https://docs.databricks.com/api/workspace/statementexecution/executestatement}{docs}
for details.}

\item{wait_timeout}{String, default is \code{"10s"}. The time in seconds the call
will wait for the statement's result set as \code{Ns}, where \code{N} can be set to
\code{0} or to a value between \code{5} and \code{50}.
When set to \verb{0s}, the statement will execute in asynchronous mode and the
call will not wait for the execution to finish. In this case, the call
returns directly with \code{PENDING} state and a statement ID which can be used
for polling with \code{\link[=db_sql_exec_status]{db_sql_exec_status()}}.

When set between \code{5} and \code{50} seconds, the call will behave synchronously up
to this timeout and wait for the statement execution to finish. If the
execution finishes within this time, the call returns immediately with a
manifest and result data (or a \code{FAILED} state in case of an execution error).

If the statement takes longer to execute, \code{on_wait_timeout} determines what
should happen after the timeout is reached.}

\item{on_wait_timeout}{One of \code{"CONTINUE"} (default) or \code{"CANCEL"}.
When \code{wait_timeout} > \verb{0s}, the call will block up to the specified time.
If the statement execution doesn't finish within this time,
\code{on_wait_timeout} determines whether the execution should continue or be
canceled.

When set to \code{CONTINUE}, the statement execution continues asynchronously and
the call returns a statement ID which can be used for polling with
\code{\link[=db_sql_exec_status]{db_sql_exec_status()}}.

When set to \code{CANCEL}, the statement execution is canceled and the call
returns with a \code{CANCELED} state.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Execute SQL Query
}
\details{
Refer to the
\href{https://docs.databricks.com/api/workspace/statementexecution/executestatement}{web documentation}
for detailed material on interaction of the various parameters and general recommendations
}
\seealso{
Other SQL Execution APIs: 
\code{\link{db_sql_exec_cancel}()},
\code{\link{db_sql_exec_result}()},
\code{\link{db_sql_exec_status}()}
}
\concept{SQL Execution APIs}
