% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusters.R
\name{get_latest_dbr}
\alias{get_latest_dbr}
\title{Get Latest Databricks Runtime (DBR)}
\usage{
get_latest_dbr(lts, ml, gpu, photon, host = db_host(), token = db_token())
}
\arguments{
\item{lts}{Boolean, if \code{TRUE} returns only LTS runtimes}

\item{ml}{Boolean, if \code{TRUE} returns only ML runtimes}

\item{gpu}{Boolean, if \code{TRUE} returns only ML GPU runtimes}

\item{photon}{Boolean, if \code{TRUE} returns only photon runtimes}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}
}
\value{
Named list
}
\description{
Get Latest Databricks Runtime (DBR)
}
\details{
There are runtime combinations that are not possible, such as GPU/ML and
photon. This function does not permit invalid combinations.
}
\seealso{
Other Clusters API: 
\code{\link{db_cluster_create}()},
\code{\link{db_cluster_edit}()},
\code{\link{db_cluster_events}()},
\code{\link{db_cluster_get}()},
\code{\link{db_cluster_list}()},
\code{\link{db_cluster_list_node_types}()},
\code{\link{db_cluster_list_zones}()},
\code{\link{db_cluster_perm_delete}()},
\code{\link{db_cluster_pin}()},
\code{\link{db_cluster_resize}()},
\code{\link{db_cluster_restart}()},
\code{\link{db_cluster_runtime_versions}()},
\code{\link{db_cluster_start}()},
\code{\link{db_cluster_terminate}()},
\code{\link{db_cluster_unpin}()},
\code{\link{get_and_start_cluster}()}

Other Cluster Helpers: 
\code{\link{get_and_start_cluster}()}
}
\concept{Cluster Helpers}
\concept{Clusters API}
