% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-structures.R
\name{email_notifications}
\alias{email_notifications}
\title{Email Notifications}
\usage{
email_notifications(
  on_start = NULL,
  on_success = NULL,
  on_failure = NULL,
  no_alert_for_skipped_runs = TRUE
)
}
\arguments{
\item{on_start}{List of email addresses to be notified when a run begins.
If not specified on job creation, reset, or update, the list is empty, and
notifications are not sent.}

\item{on_success}{List of email addresses to be notified when a run
successfully completes. A run is considered to have completed successfully if
it ends with a \code{TERMINATED} \code{life_cycle_state} and a \code{SUCCESSFUL}
\code{result_state.} If not specified on job creation, reset, or update, the list
is empty, and notifications are not sent.}

\item{on_failure}{List of email addresses to be notified when a run
unsuccessfully completes. A run is considered to have completed
unsuccessfully if it ends with an \code{INTERNAL_ERROR} \code{life_cycle_state} or a
\code{SKIPPED}, \code{FAILED}, or \code{TIMED_OUT} \code{result_state.} If this is not specified
on job creation, reset, or update the list is empty, and notifications are
not sent.}

\item{no_alert_for_skipped_runs}{If \code{TRUE} (default), do not send email to
recipients specified in \code{on_failure} if the run is skipped.}
}
\description{
Email Notifications
}
\seealso{
\code{\link[=job_task]{job_task()}}

Other Task Objects: 
\code{\link{libraries}()},
\code{\link{new_cluster}()},
\code{\link{notebook_task}()},
\code{\link{pipeline_task}()},
\code{\link{python_wheel_task}()},
\code{\link{spark_jar_task}()},
\code{\link{spark_python_task}()},
\code{\link{spark_submit_task}()}
}
\concept{Task Objects}
