% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/queries.R
\name{db_query_delete}
\alias{db_query_delete}
\title{Delete a SQL Query}
\usage{
db_query_delete(
  id,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{id}{String, ID for the query.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Delete a SQL Query
}
\details{
Moves a query to the trash. Trashed queries immediately disappear
from searches and list views, and cannot be used for alerts. You can restore
a trashed query through the UI. A trashed query is permanently deleted after
30 days.
}
\seealso{
Other SQL Queries API: 
\code{\link{db_query_create}()},
\code{\link{db_query_get}()},
\code{\link{db_query_list}()},
\code{\link{db_query_update}()}
}
\concept{SQL Queries API}
