% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secrets.R
\name{db_secrets_scope_acl_put}
\alias{db_secrets_scope_acl_put}
\title{Put ACL on Secret Scope}
\usage{
db_secrets_scope_acl_put(
  scope,
  principal,
  permission = c("READ", "WRITE", "MANAGE"),
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{scope}{Name of the scope to apply permissions.}

\item{principal}{Principal to which the permission is applied}

\item{permission}{Permission level applied to the principal. One of \code{READ},
\code{WRITE}, \code{MANAGE}.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Put ACL on Secret Scope
}
\details{
Create or overwrite the ACL associated with the given principal (user or
group) on the specified scope point. In general, a user or group will use
the most powerful permission available to them, and permissions are ordered
as follows:
\itemize{
\item \code{MANAGE} - Allowed to change ACLs, and read and write to this secret scope.
\item \code{WRITE} - Allowed to read and write to this secret scope.
\item \code{READ} - Allowed to read this secret scope and list what secrets are
available.
}

You must have the \code{MANAGE} permission to invoke this API.

The principal is a user or group name corresponding to an existing Databricks
principal to be granted or revoked access.
\itemize{
\item Throws \code{RESOURCE_DOES_NOT_EXIST} if no such secret scope exists.
\item Throws \code{RESOURCE_ALREADY_EXISTS} if a permission for the principal already
exists.
\item Throws \code{INVALID_PARAMETER_VALUE} if the permission is invalid.
\item Throws \code{PERMISSION_DENIED} if you do not have permission to make this API
call.
}
}
\seealso{
Other Secrets API: 
\code{\link{db_secrets_delete}()},
\code{\link{db_secrets_list}()},
\code{\link{db_secrets_put}()},
\code{\link{db_secrets_scope_acl_delete}()},
\code{\link{db_secrets_scope_acl_get}()},
\code{\link{db_secrets_scope_acl_list}()},
\code{\link{db_secrets_scope_create}()},
\code{\link{db_secrets_scope_delete}()},
\code{\link{db_secrets_scope_list_all}()}
}
\concept{Secrets API}
