% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jobs.R
\name{db_jobs_runs_cancel}
\alias{db_jobs_runs_cancel}
\title{Cancel Job Run}
\usage{
db_jobs_runs_cancel(
  run_id,
  host = db_host(),
  token = db_token(),
  perform_request = TRUE
)
}
\arguments{
\item{run_id}{The canonical identifier of the run.}

\item{host}{Databricks workspace URL, defaults to calling \code{\link[=db_host]{db_host()}}.}

\item{token}{Databricks workspace token, defaults to calling \code{\link[=db_token]{db_token()}}.}

\item{perform_request}{If \code{TRUE} (default) the request is performed, if
\code{FALSE} the httr2 request is returned \emph{without} being performed.}
}
\description{
Cancels a run.
}
\details{
The run is canceled asynchronously, so when this request completes, the run
may still be running. The run are terminated shortly. If the run is already
in a terminal \code{life_cycle_state}, this method is a no-op.
}
\seealso{
Other Jobs API: 
\code{\link{db_jobs_create}()},
\code{\link{db_jobs_delete}()},
\code{\link{db_jobs_get}()},
\code{\link{db_jobs_list}()},
\code{\link{db_jobs_reset}()},
\code{\link{db_jobs_run_now}()},
\code{\link{db_jobs_runs_delete}()},
\code{\link{db_jobs_runs_export}()},
\code{\link{db_jobs_runs_get}()},
\code{\link{db_jobs_runs_get_output}()},
\code{\link{db_jobs_runs_list}()},
\code{\link{db_jobs_runs_submit}()},
\code{\link{db_jobs_update}()}
}
\concept{Jobs API}
