% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_functions.R
\name{st_multibuffer}
\alias{st_multibuffer}
\title{Simulate thick margin to a landscape}
\usage{
st_multibuffer(
  sf,
  dist = 50,
  nQuadSegs = 30,
  endCapStyle = "ROUND",
  joinStyle = "ROUND",
  mitreLimit = 1
)
}
\arguments{
\item{sf}{object of class sfg, sfg or sf}

\item{dist}{numeric; buffer distance for all, or for each of the elements in x;
in case dist is a units object, it should be convertible to arc_degree if x
 has geographic coordinates, and to st_crs(x)$units otherwise}

\item{nQuadSegs}{integer; number of segments per quadrant (fourth of a circle), for all or per-feature}

\item{endCapStyle}{character; style of line ends, one of 'ROUND', 'FLAT', 'SQUARE'}

\item{joinStyle}{character; style of line joins, one of 'ROUND', 'MITRE', 'BEVEL'}

\item{mitreLimit}{numeric; limit of extension for a join if joinStyle 'MITRE' is used (default 1.0, minimum 0.0)}
}
\description{
Add buffer around each objects of a \link[sf]{sf} file
}
\details{
see package \link[sf]{st_buffer} for details
}
