% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/s3.generics.R
\name{WAIC}
\alias{WAIC}
\title{Compute the WAIC}
\usage{
WAIC(x, ..., se = FALSE)
}
\arguments{
\item{x}{A fitted model object typically of class \code{brmsfit}.}

\item{...}{Optionally more fitted model objects.}

\item{se}{A flag to indicate if the standard error of the WAIC should be estimated.
  When the samples size is low, this estimation should be interpreted with caution.}
}
\value{
If just one object is provided, a numeric value with the corresponding WAIC.
If multiple objects are provided, a named list of numeric values with the corresponding WAICs.
}
\description{
Compute the Watanabe-Akaike Information Criterion based on the posterior likelihood
}
\details{
When comparing models fitted to the same data, the smaller the WAIC, the better the fit.
}
\examples{
\dontrun{
#model with fixed effects only
fit_i1 <- brm(rating ~ treat + period + carry,
              data = inhaler, family = "gaussian", WAIC = TRUE)
WAIC(fit_i1)

#model with an additional random intercept for subjects
fit_i2 <- brm(rating ~ treat + period + carry + (1|subject),
             data = inhaler, family = "gaussian", WAIC = TRUE)
#compare both models
WAIC(fit_i1, fit_i2)
}
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
\references{
Gelman, A., Hwang, J., & Vehtari, A. (2014). Understanding predictive information criteria for Bayesian models.
Statistics and Computing, 24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation and widely applicable information criterion in singular learning theory.
The Journal of Machine Learning Research, 11, 3571-3594.
}

