% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/validate.R
\name{get_prior}
\alias{get_prior}
\title{Overview on Priors for \pkg{brms} Models}
\usage{
get_prior(formula, data = NULL, family = "gaussian", addition = NULL,
  autocor = NULL, partial = NULL, threshold = c("flexible",
  "equidistant"), internal = FALSE)
}
\arguments{
\item{formula}{An object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.
The details of model specification are given under 'Details'.}

\item{data}{An optional data frame, list or environment  (or object coercible by \code{as.data.frame} to a data frame) containing
the variables in the model. If not found in data, the variables are taken from \code{environment(formula)},
typically the environment from which \code{brm} is called. Although it is optional, we strongly recommend to supply a data.frame.}

\item{family}{A vector of one or two character strings. The first string indicates the distribution of the dependent variable (the 'family'). Currently, the following families are supported:
\code{"gaussian"}, \code{"student"}, \code{"cauchy"}, \code{"binomial"}, \code{"bernoulli"}, \code{"categorical"}, \code{"poisson"}, \code{"negbinomial"},
\code{"geometric"}, \code{"gamma"}, \cr
\code{"exponential"}, \code{"weibull"}, \code{"cumulative"}, \code{"cratio"}, \code{"sratio"}, and \code{"acat"}.
The second string indicates the link function, which must be supported by the distribution of the dependent variable.
If not specified, default link functions are used. Further information is provided under 'Details'.}

\item{addition}{A named list of one sided formulas each containing additional information on the response variable. The following names are allowed:
\code{se} for specifying standard errors for meta-analysis, \code{weights} to fit weighted regression models,
\code{trials} to specify the number of trials per observation in binomial models, \code{cat} to specify the number of categories in
categorical or ordinal models, and \code{cens} to indicate censoring. Alternatively, the \code{addition} arguments can be incorporated directly into \code{formula}.
See 'Formula Syntax' under 'Details' for further information.}

\item{autocor}{An optional \code{\link{cor_brms}} object describing the correlation structure within the response variable (i.e. the 'autocorrelation').
See the documentation of \code{\link{cor_brms}} for a description of the available correlation structures.
Defaults to NULL, corresponding to no correlations.}

\item{partial}{A one sided formula of the form \code{~expression} specifying the predictors with category specific effects in non-cumulative ordinal models
(i.e. in families \code{"cratio"}, \code{"sratio"}, or \code{"acat"}).}

\item{threshold}{A character string indicating the type of thresholds (i.e. intercepts) used in an ordinal model.
\code{"flexible"} provides the standard unstructured thresholds and \code{"equidistant"} restricts the distance between consecutive thresholds to the same value.}

\item{internal}{A flag indicating if the names of additional internal parameters should be displayed.
  Setting priors on these parameters is not recommended}
}
\value{
A data.frame with columns \code{prior}, \code{class}, \code{coef}, and \code{group}
  and several rows, each providing information on a paramter (or parameter class) on which
  priors can be specified. The prior column is empty except for internal default priors.
}
\description{
Get information on all parameters (and parameter classes) for which priors may be specified including default priors.
}
\examples{
\dontrun{
## get all parameters and parameters classes to define priors on
(prior <- get_prior(count ~ log_Age_c + log_Base4_c * Trt_c
                    + (1|patient) + (1|visit),
                    data = epilepsy, family = "poisson"))

## define a prior on all fixed effects a once
prior$prior[1] <- "normal(0,10)"

## define a specific prior on the fixed effect of Trt_c
prior$prior[5] <- "uniform(-5,5)"

## fit a model using the priors above
fit <- brm(count ~ log_Age_c + log_Base4_c * Trt_c
           + (1|patient) + (1|visit),
           data = epilepsy, family = "poisson", prior = prior)

## check that priors indeed found their way into Stan's model code
fit$model
}
}
\seealso{
\code{\link[brms:set_prior]{set_prior}}
}

