% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R
\name{plot.brmsfit}
\alias{plot.brmsfit}
\title{Trace and Density Plots for MCMC Samples}
\usage{
\method{plot}{brmsfit}(x, pars = NA, parameters = NA, N = 5, ask = TRUE,
  ...)
}
\arguments{
\item{x}{An object of class \code{brmsfit}.}

\item{pars}{Names of the parameters to plot, as given by a character vector 
or a regular expression. By default, all parameters except for random effects 
are plotted.}

\item{parameters}{A deprecated alias of \code{pars}}

\item{N}{The number of parameters plotted per page.}

\item{ask}{logical; Indicates if the user is prompted before a new page is plotted.}

\item{...}{Further arguments passed to \code{\link[gridExtra:arrangeGrob]{arrangeGrob}}.}
}
\description{
Trace and Density Plots for MCMC Samples
}
\examples{
\dontrun{ 
fit_e <- brm(count ~ log_Age_c + log_Base4_c * Trt_c + (1|patient) + (1|visit), 
             data = epilepsy, family = "poisson")
## plot fixed effects as well as standard devations of the random effects
plot(fit_e)
## plot fixed effects only and combine the chains into one posterior
plot(fit_e, pars = "^b_", combine = TRUE) 
}

}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}

