% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsformula.R
\name{brmsformula-helpers}
\alias{brmsformula-helpers}
\alias{nlf}
\alias{bf-helpers}
\alias{lf}
\alias{set_nl}
\alias{lf}
\alias{set_nl}
\title{Linear and Non-linear formulas in \pkg{brms}}
\usage{
nlf(formula, ..., flist = NULL, dpar = NULL)

lf(..., flist = NULL, dpar = NULL)

set_nl(nl = TRUE, dpar = NULL)
}
\arguments{
\item{formula}{Non-linear formula for a distributional parameter.
The name of the distributional parameter can either be specified
on the left-hand side of \code{formula} or via argument \code{dpar}.}

\item{...}{Additional \code{formula} objects to specify 
predictors of non-linear and distributional parameters. 
Formulas can either be named directly or contain
names on their left-hand side. 
The following are distributional parameters of specific families
(all other parameters are treated as non-linear parameters):
\code{sigma} (residual standard deviation or scale of
the \code{gaussian}, \code{student}, \code{lognormal} 
\code{exgaussian}, and \code{asym_laplace} families);
\code{shape} (shape parameter of the \code{Gamma},
\code{weibull}, \code{negbinomial}, and related
zero-inflated / hurdle families); \code{nu}
(degrees of freedom parameter of the \code{student} family);
\code{phi} (precision parameter of the \code{beta} 
and \code{zero_inflated_beta} families);
\code{kappa} (precision parameter of the \code{von_mises} family);
\code{beta} (mean parameter of the exponential componenent
of the \code{exgaussian} family);
\code{quantile} (quantile parameter of the \code{asym_laplace} family);
\code{zi} (zero-inflation probability); 
\code{hu} (hurdle probability);
\code{zoi} (zero-one-inflation probability);
\code{coi} (conditional one-inflation probability);
\code{disc} (discrimination) for ordinal models;
\code{bs}, \code{ndt}, and \code{bias} (boundary separation,
non-decision time, and initial bias of the \code{wiener}
diffusion model).
All distributional parameters are modeled 
on the log or logit scale to ensure correct definition
intervals after transformation.
See 'Details' for more explanation.}

\item{flist}{Optional list of formulas, which are treated in the 
same way as formulas passed via the \code{...} argument.}

\item{dpar}{Optional character string specifying the distributional 
parameter to which the formulas passed via \code{...} and
\code{flist} belong.}

\item{nl}{Logical; Indicates whether \code{formula} should be
treated as specifying a non-linear model. By default, \code{formula} 
is treated as an ordinary linear model formula.}
}
\value{
For \code{lf} and \code{nlf} a \code{list} that can be 
  passed to \code{\link[brms:brmsformula]{brmsformula}} or added 
  to an existing \code{brmsformula} object. For \code{set_nl} 
  a \code{list} that can be added to an existing
  \code{brmsformula} object.
}
\description{
Helper functions to specify linear and non-linear
formulas for use with \code{\link[brms:brmsformula]{brmsformula}}.
}
\examples{
# add more formulas to the model
bf(y ~ 1) + 
  nlf(sigma ~ a * exp(b * x), a ~ x) + 
  lf(b ~ z + (1|g), dpar = "sigma") +
  gaussian()

# specify 'nl' later on
bf(y ~ a * inv_logit(x * b)) +
  lf(a + b ~ z) +
  set_nl(TRUE)

}
\seealso{
\code{\link[brms:brmsformula]{brmsformula}}
}
