% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{addition-terms}
\alias{addition-terms}
\alias{resp_cat}
\alias{resp_cens}
\alias{resp_dec}
\alias{resp_disp}
\alias{resp_se}
\alias{resp_trials}
\alias{resp_trunc}
\alias{resp_weights}
\title{Additional Response Information}
\usage{
resp_se(x, sigma = FALSE)

resp_weights(x)

resp_disp(x)

resp_trials(x)

resp_cat(x)

resp_dec(x)

resp_cens(x, y2 = NULL)

resp_trunc(lb = -Inf, ub = Inf)
}
\arguments{
\item{x}{A vector; usually a variable defined in the
data. Allowed values depend on the function:
\code{resp_se}, \code{resp_weights}, and \code{resp_disp} 
require positive numeric values;
\code{resp_trials} and \code{resp_cat} require positive integers;
\code{resp_dec} requires \code{0} and \code{1}, or alternatively
\code{'lower'} and \code{'upper'}; 
\code{resp_cens} requires \code{'left'}, \code{'none'}, \code{'right'},
and \code{'interval'} (or equivalenty \code{-1}, \code{0}, \code{1},
and \code{2}) to indicate left, no, right, or interval censoring.}

\item{sigma}{Logical; Indicates whether the residual standard deviation
parameter \code{sigma} should be included in addition to the known
measurement error. Defaults to \code{FALSE} for backwards compatibility,
but setting it to \code{TRUE} is usually the better choice.}

\item{y2}{A vector specifying the upper bounds in interval censoring.}

\item{lb}{A numeric vector or single numeric value specifying 
the lower truncation bound.}

\item{ub}{A numeric vector or single numeric value specifying 
the upper truncation bound.}
}
\value{
A vector containing additional information on the response
  variable in an appropriate format.
}
\description{
Provide additional information on the response variable 
in \pkg{brms} models, such as censoring, truncation, or
known measurement error.
}
\details{
These functions are almost solely useful when
  called in formulas passed to the \pkg{brms} package.
  Within formulas, the \code{resp_} prefix may be omitted.
  More information is given in the 'Details' section
  of \code{\link[brms:brmsformula]{brmsformula}}.
}
\examples{
\dontrun{
## Random effects meta-analysis
nstudies <- 20
true_effects <- rnorm(nstudies, 0.5, 0.2)
sei <- runif(nstudies, 0.05, 0.3)
outcomes <- rnorm(nstudies, true_effects, sei)
data1 <- data.frame(outcomes, sei)
fit1 <- brm(outcomes | se(sei, sigma = TRUE) ~ 1,
            data = data1)
summary(fit1)

## Probit regression using the binomial family
n <- sample(1:10, 100, TRUE)  # number of trials
success <- rbinom(100, size = n, prob = 0.4)
x <- rnorm(100)
data2 <- data.frame(n, success, x)
fit2 <- brm(success | trials(n) ~ x, data = data2,
            family = binomial("probit"))
summary(fit2)

## Survival regression modeling the time between the first 
## and second recurrence of an infection in kidney patients.
fit3 <- brm(time | cens(censored) ~ age * sex + disease + (1|patient), 
            data = kidney, family = lognormal())
summary(fit3)

## Poisson model with truncated counts  
fit4 <- brm(count | trunc(ub = 104) ~ log_Base4_c * Trt_c, 
            data = epilepsy, family = poisson())
summary(fit4)
}
  
}
\seealso{
\code{\link[brms:brm]{brm}}, 
  \code{\link[brms:brmsformula]{brmsformula}}
}

