% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{LOO.brmsfit}
\alias{LOO.brmsfit}
\alias{LOO}
\alias{LOO.brmsfit}
\alias{loo.brmsfit}
\alias{loo}
\title{Compute the LOO information criterion}
\usage{
\method{LOO}{brmsfit}(x, ..., compare = TRUE, reloo = FALSE,
  newdata = NULL, re_formula = NULL, allow_new_levels = FALSE,
  sample_new_levels = "uncertainty", resp = NULL, new_objects = list(),
  subset = NULL, nsamples = NULL, pointwise = NULL, nug = NULL,
  k_threshold = 0.7, update_args = list(), cores = 1, wcp = 0.2,
  wtrunc = 3/4)

LOO(x, ...)
}
\arguments{
\item{x}{A fitted model object typically of class \code{brmsfit}.}

\item{...}{Optionally more fitted model objects.}

\item{compare}{A flag indicating if the information criteria
of the models should be compared to each other
via \code{\link[brms:compare_ic]{compare_ic}}.}

\item{reloo}{Logical; Indicate whether 
\code{\link[brms:reloo]{reloo}} should be applied
on problematic observations. Defaults to \code{FALSE}.}

\item{newdata}{An optional data.frame for which to evaluate predictions.
If \code{NULL} (default), the original data of the model is used.}

\item{re_formula}{formula containing group-level effects 
to be considered in the prediction. 
If \code{NULL} (default), include all group-level effects; 
if \code{NA}, include no group-level effects.}

\item{allow_new_levels}{A flag indicating if new
levels of group-level effects are allowed 
(defaults to \code{FALSE}). 
Only relevant if \code{newdata} is provided.}

\item{sample_new_levels}{Indicates how to sample new levels 
for grouping factors specified in \code{re_formula}.
This argument is only relevant if \code{newdata} is provided and 
\code{allow_new_levels} is set to \code{TRUE}.
If \code{"uncertainty"} (default), include group-level uncertainty
in the predictions based on the variation of the existing levels. 
If \code{"gaussian"}, sample new levels from the (multivariate) 
normal distribution implied by the group-level standard deviations 
and correlations. This options may be useful for conducting 
Bayesian power analysis. 
If \code{"old_levels"}, directly sample new levels from the
existing levels.}

\item{resp}{Optional names of response variables.
If specified, fitted values of these response variables are returned.}

\item{new_objects}{A named \code{list} of objects containing 
new data, which cannot be passed via argument \code{newdata}.
Currently, only required for objects passed to 
\code{\link[brms:cor_sar]{cor_sar}} and 
\code{\link[brms:cor_fixed]{cor_fixed}}.}

\item{subset}{A numeric vector specifying
the posterior samples to be used. 
If \code{NULL} (the default), all samples are used.}

\item{nsamples}{Positive integer indicating how many 
posterior samples should be used. 
If \code{NULL} (the default) all samples are used.
Ignored if \code{subset} is not \code{NULL}.}

\item{pointwise}{A flag indicating whether to compute the full
log-likelihood matrix at once or separately for each observation. 
The latter approach is usually considerably slower but 
requires much less working memory. Accordingly, if one runs 
into memory issues, \code{pointwise = TRUE} is the way to go.
By default, \code{pointwise} is automatically chosen based on 
the size of the model.}

\item{nug}{Small positive number for Gaussian process terms only. 
For numerical reasons, the covariance matrix of a Gaussian 
process might not be positive definite. Adding a very small 
number to the matrix's diagonal often solves this problem. 
If \code{NULL} (the default), \code{nug} is chosen internally.}

\item{k_threshold}{The threshold at which pareto \eqn{k} 
estimates are treated as problematic. Defaults to \code{0.7}. 
Only used if argument \code{reloo} is \code{TRUE}.
See \code{\link[loo:pareto_k_ids]{pareto_k_ids}}
for more details.}

\item{update_args}{A \code{list} of further arguments passed to 
\code{\link[brms:update.brmsfit]{update.brmsfit}} such
as \code{iter}, \code{chains}, or \code{cores}.}

\item{cores}{The number of cores to use for parallelization. 
Default is \code{1}.}

\item{wcp, wtrunc}{Parameters used for 
the Pareto smoothed importance sampling. 
See \code{\link[loo:loo]{loo}} for details.}
}
\value{
If just one object is provided, an object of class \code{ic}. 
 If multiple objects are provided, an object of class \code{iclist}.
}
\description{
Perform approximate leave-one-out cross-validation based 
on the posterior likelihood using the \pkg{loo} package.
}
\details{
When comparing models fitted to the same data, 
 the smaller the LOO, the better the fit.
 For \code{brmsfit} objects, \code{loo} is an alias of \code{LOO}.
 Use method \code{\link[brms:add_ic]{add_ic}} to store
 information criteria in the fitted model object for later usage.
}
\section{Methods (by class)}{
\itemize{
\item \code{brmsfit}: \code{LOO} method for \code{brmsfit} objects
}}

\examples{
\dontrun{
# model with population-level effects only
fit1 <- brm(rating ~ treat + period + carry,
            data = inhaler, family = "gaussian")
LOO(fit1)

# model with an additional varying intercept for subjects
fit2 <- brm(rating ~ treat + period + carry + (1|subject),
            data = inhaler, family = "gaussian")
# compare both models
LOO(fit1, fit2)                          
}

}
\references{
Vehtari, A., Gelman, A., & Gabry J. (2016). Practical Bayesian model
evaluation using leave-one-out cross-validation and WAIC. In Statistics 
and Computing, doi:10.1007/s11222-016-9696-4. arXiv preprint arXiv:1507.04544.

Gelman, A., Hwang, J., & Vehtari, A. (2014). 
Understanding predictive information criteria for Bayesian models. 
Statistics and Computing, 24, 997-1016.

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross validation 
and widely applicable information criterion in singular learning theory. 
The Journal of Machine Learning Research, 11, 3571-3594.
}
\author{
Paul-Christian Buerkner \email{paul.buerkner@gmail.com}
}
