% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formula-helpers.R
\name{mm}
\alias{mm}
\title{Set up multi-membership grouping terms in \pkg{brms}}
\usage{
mm(..., weights = NULL, scale = TRUE)
}
\arguments{
\item{...}{One or more terms containing grouping factors.}

\item{weights}{A matrix specifying the weights of each member.
It should have as many columns as grouping terms specified in \code{...}.
If \code{NULL} (the default), equally weights are used.}

\item{scale}{Logical; if \code{TRUE} (the default), 
weights are standardized in order to sum to one per row.
If negative weights are specified, \code{scale} needs
to be set to \code{FALSE}.}
}
\description{
Function to set up a multi-membership grouping term in \pkg{brms}.
The function does not evaluate its arguments --
it exists purely to help set up a model with grouping terms.
}
\examples{
\dontrun{
# simulate some data
dat <- data.frame(
 y = rnorm(100), x1 = rnorm(100), x2 = rnorm(100),
 g1 = sample(1:10, 100, TRUE), g2 = sample(1:10, 100, TRUE)
)

# multi-membership model with two members per group and equal weights
fit1 <- brm(y ~ x1 + (1|mm(g1, g2)), data = dat)
summary(fit1)

# weight the first member two times for than the second member
dat$w1 <- rep(2, 100)
dat$w2 <- rep(1, 100)
fit2 <- brm(y ~ x1 + (1|mm(g1, g2, weights = cbind(w1, w2))), data = dat)
summary(fit2)

# multi-membership model with level specific covariate values
dat$xc <- (dat$x1 + dat$x2) / 2
fit3 <- brm(y ~ xc + (1 + mmc(x1, x2) | mm(g1, g2)), data = dat)
summary(fit3)
}
  
}
\seealso{
\code{\link{brmsformula}}, \code{\link{mmc}}
}
