% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brmsfit-methods.R, R/generics.R
\name{pp_average.brmsfit}
\alias{pp_average.brmsfit}
\alias{pp_average}
\title{Posterior predictive samples averaged across models}
\usage{
\method{pp_average}{brmsfit}(x, ..., weights = "loo2", method = c("predict",
  "fitted", "residuals"), nsamples = NULL, summary = TRUE,
  probs = c(0.025, 0.975), robust = FALSE, model_names = NULL,
  control = list(), seed = NULL)

pp_average(x, ...)
}
\arguments{
\item{x}{A fitted model object.}

\item{...}{More fitted model objects or further arguments
passed to the underlying post-processing functions.}

\item{weights}{Name of the criterion to compute weights from. 
Should be one of \code{"loo"}, \code{"waic"}, \code{"kfold"}, 
\code{"loo2"} (current default), or \code{"marglik"}. 
For the former three options, Akaike weights will be computed
based on the information criterion values returned by
the respective methods. For \code{"loo2"}, method
\code{\link{loo_model_weights}} will be used to obtain weights. 
For \code{"marglik"}, method \code{\link{post_prob}} 
will be used to compute weights based on log marginal 
likelihood values (make sure to specify reasonable priors in 
this case). Alternatively, \code{weights} can be a numeric vector 
of pre-specified weights.}

\item{method}{Type of predictions to average. Should be one of 
\code{"predict"} (default), \code{"fitted"}, or \code{"residuals"}.}

\item{nsamples}{Total number of posterior samples to use.}

\item{summary}{Should summary statistics 
 (i.e. means, sds, and 95\% intervals) be returned
instead of the raw values? Default is \code{TRUE}.}

\item{probs}{The percentiles to be computed by the \code{quantile} 
function. Only used if \code{summary} is \code{TRUE}.}

\item{robust}{If \code{FALSE} (the default) the mean is used as 
the measure of central tendency and the standard deviation as 
the measure of variability. If \code{TRUE}, the median and the 
median absolute deviation (MAD) are applied instead.
Only used if \code{summary} is \code{TRUE}.}

\item{model_names}{If \code{NULL} (the default) will use model names 
derived from deparsing the call. Otherwise will use the passed 
values as model names.}

\item{control}{Optional \code{list} of further arguments 
passed to the function specified in \code{weights}.}

\item{seed}{A single numeric value passed to \code{\link{set.seed}}
to make results reproducible.}
}
\value{
Same as the output of the method specified 
  in argument \code{method}.
}
\description{
Compute posterior predictive samples averaged across models.
Weighting can be done in various ways, for instance using
Akaike weights based on information criteria or 
marginal likelihoods.
}
\details{
Weights are computed with the \code{\link{model_weights}} method.
}
\examples{
\dontrun{
# model with 'treat' as predictor
fit1 <- brm(rating ~ treat + period + carry, data = inhaler)
summary(fit1)

# model without 'treat' as predictor
fit2 <- brm(rating ~ period + carry, data = inhaler)
summary(fit2)

# compute model-averaged predicted values
(df <- unique(inhaler[, c("treat", "period", "carry")]))
pp_average(fit1, fit2, newdata = df)

# compute model-averaged fitted values
pp_average(fit1, fit2, method = "fitted", newdata = df)
}

}
\seealso{
\code{\link{model_weights}}, \code{\link{posterior_average}}
}
