% Generated by roxygen2 (4.0.2): do not edit by hand
\name{anova_tidiers}
\alias{anova_tidiers}
\alias{tidy.anova}
\alias{tidy.aov}
\title{Tidying methods for anova and AOV objects}
\usage{
\method{tidy}{anova}(x, ...)

\method{tidy}{aov}(x, ...)
}
\arguments{
\item{x}{An object of class "anova" or "aov"}

\item{...}{extra arguments (not used)}
}
\value{
A data.frame with columns
  \item{term}{Term within the model, or "Residuals"}
  \item{df}{Degrees of freedom used by this term in the model}
  \item{sumsq}{Sum of squares explained by this term}
  \item{meansq}{Mean of sum of squares among degrees of freedom}
  \item{statistic}{F statistic}
  \item{p.value}{P-value from F test}
}
\description{
Tidies the result of an analysis of variance into an ANOVA table.
Only a \code{tidy} method is provided, not an \code{augment} or
\code{glance} method.
}
\examples{
a <- anova(lm(mpg ~ wt + qsec + disp, mtcars))
tidy(a)

a <- aov(mpg ~ wt + qsec + disp, mtcars)
tidy(a)
}

