% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sp_tidiers}
\alias{sp_tidiers}
\alias{tidy.Line}
\alias{tidy.Lines}
\alias{tidy.Polygon}
\alias{tidy.Polygons}
\alias{tidy.SpatialLinesDataFrame}
\alias{tidy.SpatialPolygons}
\alias{tidy.SpatialPolygonsDataFrame}
\title{tidying methods for classes from the sp package.}
\usage{
\method{tidy}{SpatialPolygonsDataFrame}(x, region = NULL, ...)

\method{tidy}{SpatialPolygons}(x, ...)

\method{tidy}{Polygons}(x, ...)

\method{tidy}{Polygon}(x, ...)

\method{tidy}{SpatialLinesDataFrame}(x, ...)

\method{tidy}{Lines}(x, ...)

\method{tidy}{Line}(x, ...)
}
\arguments{
\item{x}{\code{SpatialPolygonsDataFrame} to convert into a dataframe.}

\item{region}{name of variable used to split up regions}

\item{...}{not used by this method}
}
\description{
Tidy classes from the sp package to allow them to be plotted using ggplot2.
To figure out the correct variable name for region, inspect
\code{as.data.frame(x)}.
}
\details{
These functions originated in the ggplot2 package as "fortify" functions.
}
\examples{
if (require("maptools")) {
    sids <- system.file("shapes/sids.shp", package="maptools")
    nc1 <- readShapePoly(sids,
    proj4string = CRS("+proj=longlat +datum=NAD27"))
    nc1_df <- tidy(nc1)
}
}

