% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boot_tidiers.R
\name{boot_tidiers}
\alias{boot_tidiers}
\alias{tidy.boot}
\title{Tidying methods for bootstrap computations}
\usage{
\method{tidy}{boot}(x, conf.int = FALSE, conf.level = 0.95,
  conf.method = "perc", ...)
}
\arguments{
\item{x}{\code{\link{boot}} object}

\item{conf.int}{whether to include a confidence interval}

\item{conf.level}{confidence level for CI}

\item{conf.method}{method for computing confidence intervals (see \code{\link{boot.ci}})}

\item{\dots}{extra arguments (not used)}
}
\value{
The \code{tidy} method returns a data frame with one row per
bootstrapped statistic that was calculated, and the
following columns:
  \item{term}{Name of the computed statistic, if present}
  \item{statistic}{The original values of the statistic}
  \item{bias}{The bias of the original statistic value}
  \item{std.error}{Standard error of the statistic}

If weights were provided to the \code{boot} function, an \code{estimate}
column is included showing the weighted bootstrap estimate, and the
standard error is of that estimate.

If there are no original statistics in the "boot" object, such as with a
call to \code{tsboot} with \code{orig.t = FALSE}, the \code{original}
and \code{statistic} columns are omitted, and only \code{estimate} and
\code{std.error} columns shown.
}
\description{
Tidying methods for "boot" objects from the "boot" package.
}
\examples{
if (require("boot")) {
   clotting <- data.frame(
          u = c(5,10,15,20,30,40,60,80,100),
          lot1 = c(118,58,42,35,27,25,21,19,18),
          lot2 = c(69,35,26,21,18,16,13,12,12))

   g1 <- glm(lot2 ~ log(u), data = clotting, family = Gamma)
   
   bootfun <- function(d, i) {
      coef(update(g1, data= d[i,]))
   }
   bootres <- boot(clotting, bootfun, R = 999)
   tidy(g1, conf.int=TRUE)
   tidy(bootres, conf.int=TRUE)
}

}

