% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival_tidiers.R
\name{sexpfit_tidiers}
\alias{glance.survexp}
\alias{sexpfit_tidiers}
\alias{tidy.survexp}
\title{Tidy an expected survival curve}
\usage{
\method{tidy}{survexp}(x, ...)

\method{glance}{survexp}(x, ...)
}
\arguments{
\item{x}{"survexp" object}

\item{...}{extra arguments (not used)}
}
\value{
All tidying methods return a data.frame without rownames, whose
structure depends on the method chosen.

\code{tidy} returns a one row for each time point, with columns
  \item{time}{time point}
  \item{estimate}{estimated survival}
  \item{n.risk}{number of individuals at risk}

\code{glance} returns a one-row data.frame with the columns:
  \item{n.max}{maximum number of subjects at risk}
  \item{n.start}{starting number of subjects at risk}
  \item{timepoints}{number of timepoints}
}
\description{
This constructs a summary across time points or overall of an expected survival
curve. Note that this contains less information than most survfit objects.
}
\examples{

if (require("survival", quietly = TRUE)) {
    sexpfit <- survexp(futime ~ 1, rmap=list(sex="male", year=accept.dt,
                                             age=(accept.dt-birth.dt)),
                       method='conditional', data=jasa)

    tidy(sexpfit)
    glance(sexpfit)
}

}

