% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bingroup_tidiers.R
\name{binWidth_tidiers}
\alias{binWidth_tidiers}
\alias{tidy.binWidth}
\title{Tidy a binWidth object}
\usage{
\method{tidy}{binWidth}(x, ...)
}
\arguments{
\item{x}{A "binWidth" object}

\item{...}{Extra arguments (not used)}
}
\value{
A one-row data.frame with columns:
  \item{ci.width}{Expected width of confidence interval}
  \item{alternative}{Alternative hypothesis}
  \item{p}{True proportion}
  \item{n}{Total sample size}
}
\description{
Tidy a binWidth object from the "binGroup" package,
which calculates the expected width of a confidence
interval from a binomial test.
}
\examples{

if (require("binGroup", quietly = TRUE)) {
    bw <- binWidth(100, .1)
    bw
    tidy(bw)
    
    library(dplyr)
    d <- expand.grid(n = seq(100, 800, 100),
                     p = .5,
                     method = c("CP", "Blaker", "Score", "Wald"),
                     stringsAsFactors = FALSE) \%>\%
        group_by(n, p, method) \%>\%
        do(tidy(binWidth(.$n, .$p, method = .$method)))
    
    library(ggplot2)
    ggplot(d, aes(n, ci.width, color = method)) +
        geom_line() +
        xlab("Total Observations") +
        ylab("Expected CI Width")
}

}

