% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{tidy}
\alias{tidy}
\title{Retrieve tidy dataframe if it exists.}
\usage{
tidy(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble()}} with information about model components.
}
\description{
Checks if a \code{tidy} method exits for a given object, either in \code{broom} or in
\code{broom.mixed}. If it does, it turn an object into a tidy tibble, if not,
return a \code{NULL}. In this case, you can try the
\code{\link[=tidy_parameters]{tidy_parameters()}} function.
}
\examples{
set.seed(123)
lm.mod <- lm(Sepal.Length ~ Species, iris)
broomExtra::tidy(x = lm.mod, conf.int = TRUE)
}
\seealso{
\code{\link{grouped_tidy}}, \code{\link{tidy_parameters}}
}
