% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bruceR_stats_04_regress.R
\name{regress}
\alias{regress}
\title{Regression analysis.}
\usage{
regress(
  formula,
  data,
  family = NULL,
  digits = 3,
  nsmall = digits,
  robust = FALSE,
  cluster = NULL,
  test.rand = FALSE
)
}
\arguments{
\item{formula}{Model formula.}

\item{data}{Data frame.}

\item{family}{[Optional] The same as in \code{glm} and \code{glmer} (e.g., \code{family=binomial} fits a logistic regression model).}

\item{digits}{Number of decimal places of output. Default is 3.}

\item{nsmall}{Number of decimal places of output. Default is 3.}

\item{robust}{[Only for \code{lm} and \code{glm}]
\code{FALSE} (default), \code{TRUE} (then the default is \code{"HC1"}),
\code{"HC0"}, \code{"HC1"}, \code{"HC2"}, \code{"HC3"}, \code{"HC4"}, \code{"HC4m"}, or \code{"HC5"}.
It will add a table with heteroskedasticity-robust standard errors (aka. Huber-White standard errors).
For details, see \code{?sandwich::vcovHC} and \code{?jtools::summ.lm}.

*** \code{"HC1"} is the default of Stata, whereas \code{"HC3"} is the default suggested by the \code{sandwich} package.}

\item{cluster}{[Only for \code{lm} and \code{glm}]
Cluster-robust standard errors are computed if cluster is set to the name of the input data's cluster variable or is a vector of clusters.}

\item{test.rand}{[Only for \code{lmer} and \code{glmer}]
\code{TRUE} or \code{FALSE} (default).
Test random effects (i.e., variance components) by using the likelihood-ratio test (LRT),
which is asymptotically chi-square distributed.
For large datasets, it is much time-consuming.}
}
\value{
No return value.
}
\description{
NOTE: \code{\link{model_summary}} is preferred.
}
\examples{
\dontrun{

  ## lm
  regress(Temp ~ Month + Day + Wind + Solar.R, data=airquality, robust=TRUE)

  ## glm
  regress(case ~ age + parity + education + spontaneous + induced,
          data=infert, family=binomial, robust="HC1", cluster="stratum")

  ## lmer
  library(lmerTest)
  regress(Reaction ~ Days + (Days | Subject), data=sleepstudy)
  regress(Preference ~ Sweetness + Gender + Age + Frequency +
            (1 | Consumer), data=carrots)

  ## glmer
  library(lmerTest)
  data.glmm=MASS::bacteria
  regress(y ~ trt + week + (1 | ID), data=data.glmm, family=binomial)
  regress(y ~ trt + week + hilo + (1 | ID), data=data.glmm, family=binomial)
}

}
\seealso{
\code{\link{print_table}} (print simple table)

\code{\link{model_summary}} (highly suggested)

\code{\link{GLM_summary}}

\code{\link{HLM_summary}}
}
