% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update-functions.R
\name{bs4RemoveTab}
\alias{bs4RemoveTab}
\title{Remove a \link{bs4TabPanel} in a \link{bs4TabSetPanel}}
\usage{
bs4RemoveTab(inputId, target, session = shiny::getDefaultReactiveDomain())
}
\arguments{
\item{inputId}{\link{bs4TabSetPanel} id.}

\item{target}{\link{bs4TabPanel} to remove.}

\item{session}{Shiny session object.}
}
\description{
Remove a \link{bs4TabPanel} in a \link{bs4TabSetPanel}
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 ui <-  bs4DashPage(
   sidebar_collapsed = TRUE,
   sidebar = bs4DashSidebar(),
   bs4DashFooter(),
   body = bs4DashBody(
     actionButton("remove1","Remove tab 1"),
     bs4TabSetPanel(
       id = "tabset1", 
       side = "left",
       bs4TabPanel(
         tabName = "Tab 1",
         active = TRUE,
         p("Text 1"),
       ),
       bs4TabPanel(
         tabName = "Tab 2",
         active = FALSE,
         p("Text 2"),
       )
     ),
     actionButton("remove2","Remove tab 2"),
     bs4TabSetPanel(
       id = "tabset2", 
       side = "left",
       bs4TabPanel(
         tabName = "Tab 1",
         active = TRUE,
         p("Text 1"),
       ),
       bs4TabPanel(
         tabName = "Tab 2",
         active = FALSE,
         p("Text 2"),
       )
     )
   )
 )
 
 server <- function(input, output, session) {
   
   observeEvent(input$remove1, {
     bs4RemoveTab(
       inputId = "tabset1",
       target = "Tab 1"
     )
   })
   
   observeEvent(input$remove2, {
     bs4RemoveTab(
       inputId = "tabset2",
       target = "Tab 2",
     )
   })
   
 }
 shinyApp(ui, server)
}
}
