% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inputs.R
\name{appButton}
\alias{appButton}
\title{AdminLTE2 special large button}
\usage{
appButton(..., inputId, label, icon = NULL, width = NULL, color = NULL)
}
\arguments{
\item{...}{Named attributes to be applied to the button or link.}

\item{inputId}{The \code{input} slot that will be used to access the value.}

\item{label}{The contents of the button or link--usually a text label, but
you could also use any other HTML, like an image.}

\item{icon}{An optional \code{\link[shiny:icon]{icon()}} to appear on the button.}

\item{width}{The width of the input, e.g. \code{'400px'}, or \code{'100\%'};
see \code{\link[shiny:reexports]{validateCssUnit()}}.}

\item{color}{Button backgroun color. Valid statuses are defined as follows:
\itemize{
  \item \code{primary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#007bff")}.
  \item \code{secondary}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6c757d")}.
  \item \code{info}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#17a2b8")}.
  \item \code{success}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#28a745")}.
  \item \code{warning}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ffc107")}.
  \item \code{danger}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#dc3545")}.
  \item \code{gray-dark}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#343a40")}.
  \item \code{gray}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#adb5bd")}.
  \item \code{white}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#fff")}.
  \item \code{indigo}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#6610f2")}.
  \item \code{lightblue}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3c8dbc")}.
  \item \code{navy}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#001f3f")}.
  \item \code{purple}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#605ca8")}.
  \item \code{fuchsia}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#f012be")}.
  \item \code{pink}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#e83e8c")}.
  \item \code{maroon}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#d81b60")}.
  \item \code{orange}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#ff851b")}.
  \item \code{lime}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#01ff70")}.
  \item \code{teal}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#39cccc")}.
  \item \code{olive}: \Sexpr[results=rd, stage=render]{bs4Dash:::rd_color_tag("#3d9970")}.
}}
}
\description{
Create a large button ideal for web applications but identical
to the classic Shiny action button.
}
\examples{
if (interactive()) {
 library(shiny)
 library(bs4Dash)
 
 shinyApp(
  ui = dashboardPage(
    dashboardHeader(),
    dashboardSidebar(),
    dashboardBody(
     box(
      title = "App Buttons",
      status = NULL,
      appButton(
        inputId = "myAppButton",
        label = "Users", 
        icon = icon("users"), 
        color = "orange",
        dashboardBadge(textOutput("btnVal"), color = "primary")
      )
     )
    ),
    title = "App buttons"
  ),
  server = function(input, output) {
   output$btnVal <- renderText(input$myAppButton)
  }
 )
}

}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
