% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cards.R, R/aliases.R
\name{bs4SocialCard}
\alias{bs4SocialCard}
\alias{userBlock}
\alias{cardComment}
\alias{socialBox}
\alias{boxComment}
\title{AdminLTE3 social card}
\usage{
bs4SocialCard(
  ...,
  title = NULL,
  footer = NULL,
  width = 6,
  height = NULL,
  collapsible = TRUE,
  collapsed = FALSE,
  closable = FALSE,
  maximizable = FALSE,
  boxToolSize = "sm",
  elevation = NULL,
  headerBorder = TRUE,
  label = NULL,
  dropdownMenu = NULL,
  sidebar = NULL,
  id = NULL
)

userBlock(image, title, subtitle = NULL)

cardComment(..., image, title = NULL, date = NULL)

socialBox(
  ...,
  title = NULL,
  footer = NULL,
  width = 6,
  height = NULL,
  collapsible = TRUE,
  collapsed = FALSE,
  closable = FALSE,
  maximizable = FALSE,
  boxToolSize = "sm",
  elevation = NULL,
  headerBorder = TRUE,
  label = NULL,
  dropdownMenu = NULL,
  sidebar = NULL,
  id = NULL
)

boxComment(..., image, title = NULL, date = NULL)
}
\arguments{
\item{...}{Comment content.}

\item{title}{Comment title.}

\item{footer}{Optional footer text.}

\item{width}{The width of the box, using the Bootstrap grid system. This is
used for row-based layouts. The overall width of a region is 12, so the
default card width of 6 occupies 1/2 of that width. For column-based
layouts, use \code{NULL} for the width; the width is set by the column that
contains the box.}

\item{height}{The height of a box, in pixels or other CSS unit. By default
the height scales automatically with the content.}

\item{collapsible}{If TRUE, display a button in the upper right that allows
the user to collapse the box.}

\item{collapsed}{If TRUE, start collapsed. This must be used with
\code{collapsible=TRUE}.}

\item{closable}{If TRUE, display a button in the upper right that allows the user to close the box.}

\item{maximizable}{If TRUE, the card can be displayed in full screen mode.}

\item{boxToolSize}{Size of the toolbox: choose among "xs", "sm", "md", "lg".}

\item{elevation}{Card elevation.}

\item{headerBorder}{Whether to display a border between the header and body.
TRUE by default}

\item{label}{Slot for \link{boxLabel}.}

\item{dropdownMenu}{List of items in the boxtool dropdown menu. Use \link{boxDropdown}.}

\item{sidebar}{Slot for \link{boxSidebar}.}

\item{id}{Card id.}

\item{image}{Author image, if any.}

\item{subtitle}{Any subtitle.}

\item{date}{Date of publication.}
}
\description{
\link{socialBox} Creates social card

\link{userBlock} goes in the title of \link{socialBox}.

Create a card comment to insert in \link{socialBox}
}
\examples{
if (interactive()) {
  library(shiny)
  library(bs4Dash)

  shinyApp(
    ui = dashboardPage(
      dashboardHeader(),
      dashboardSidebar(),
      dashboardBody(
        socialBox(
          title = userBlock(
            image = "https://adminlte.io/themes/AdminLTE/dist/img/user4-128x128.jpg",
            title = "Social Box",
            subtitle = "example-01.05.2018"
          ),
          "Some text here!",
          attachmentBlock(
            image = "https://adminlte.io/themes/v3/dist/img/user1-128x128.jpg",
            title = "Test",
            href = "https://google.com",
            "This is the content"
          ),
          lapply(X = 1:10, FUN = function(i) {
            boxComment(
              image = "https://adminlte.io/themes/AdminLTE/dist/img/user3-128x128.jpg",
              title = paste("Comment", i),
              date = "01.05.2018",
              paste0("The ", i, "-th comment")
            )
          }),
          footer = "The footer here!"
        )
      ),
      controlbar = dashboardControlbar(),
      title = "socialBox"
    ),
    server = function(input, output) { }
  )
}
}
\seealso{
Other cards: 
\code{\link{bs4CardLayout}()},
\code{\link{bs4TabCard}()},
\code{\link{bs4UserCard}()},
\code{\link{descriptionBlock}()},
\code{\link{renderbs4InfoBox}()},
\code{\link{renderbs4ValueBox}()}

Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}

Other boxWidgets: 
\code{\link{attachmentBlock}()},
\code{\link{bs4CardLabel}()},
\code{\link{bs4CardSidebar}()},
\code{\link{bs4Carousel}()},
\code{\link{bs4Timeline}()},
\code{\link{cardDropdown}()},
\code{\link{cardProfile}()},
\code{\link{descriptionBlock}()},
\code{\link{userPost}()}
}
\author{
David Granjon, \email{dgranjon@ymail.com}
}
\concept{boxWidgets}
\concept{cards}
