% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.R
\name{bs_navbar}
\alias{bs_navbar}
\title{Create a Bootstrap navbar}
\usage{
bs_navbar(
  brand = list(),
  from_left = list(),
  from_right = list(),
  id = sampleStr(10),
  navbar_class = "navbar",
  background_class = "bg-primary",
  text_class = "navbar-dark",
  background_color = NULL,
  expand = "lg",
  fluid = FALSE,
  ul_class = "navbar-nav",
  li_class = "nav-item",
  a_class = "nav-link"
)
}
\arguments{
\item{brand}{A named list of length 1, name should be a value suitable for the href param of html5::a()
and the value is the HTML or text to display in the a tag.}

\item{from_left}{A list, creates navbar elements arranged to the left. If a list item is named,
names should be links and values should be text to display in the navbar for that link. Names will be passed to the
href param and values to the main content of the html5::a() function which will be wrapped by the html5::li() function,
each of which have Bootstrap classes added by default.If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually. For example, to add a drop-down, add an unnamed item to the list
with HTML defining the drop-down as the value of the item.}

\item{from_right}{A list, creates navbar elements arranged to the right. If a list item is named,
names should be links and values should be text to display in the navbar for that link. Names will be passed to the
href param and values to the main content of the html5::a() function which will be wrapped by the html5::li() function,
each of which have Bootstrap classes added by default. If an item in the list is not named, the item must be
valid HTML with appropriate Bootstrap classes added manually. For example, to add a drop-down, add an unnamed item to the list
with HTML defining the drop-down as the value of the item.}

\item{id}{A string, used to control the collapse/expand functionality. Defaults to a random string.}

\item{navbar_class}{A string, the class passed to the nav tag.}

\item{background_class}{A string, a Bootstrap background class such as "bg-primary" that gets appended to navbar_class.}

\item{text_class}{A string, a Bootstrap navbar text class such as "navbar-dark" that gets appended to navbar_class.}

\item{background_color}{A string, a CSS color (ex. "#00FFFF"). Background-class will overrule this, so setting background_class to NULL
will ensure the background color is applied.}

\item{expand}{A string, the break-point at which the navbar should expand or collapse.  One of "sm", "md", "lg", "xl", "xxl".
If NULL, does not add classes to expand or collapse.}

\item{fluid}{TRUE/FALSE, if TRUE, makes the container wrapping the navbar elements fluid (use the entire screen width or not).}

\item{ul_class}{A string, default class used for the "ul" tag wrapping the navbar elements.}

\item{li_class}{A string, default class used for the "li" tags wrapping the navbar elements if the input list item is named.}

\item{a_class}{A string, default class used for the "a" tags wrapping the navbar elements if the input list item is named.}
}
\value{
A string of HTML.
}
\description{
Create a Bootstrap navbar
}
\examples{
bs_navbar(
fluid = TRUE,
brand = list("#" = "Sample Brand"),
from_left = list(
  "/" = "Home",
  "/about" = "About"
),
from_right = list(
  "/options" = "Options"
)
)
}
