% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dat4jags.R
\name{dat4jags}
\alias{dat4jags}
\title{Correlated Random Walk Filter}
\usage{
dat4jags(d, tstep = 1, tpar = tpar())
}
\arguments{
\item{d}{a data frame of observations (see details)}

\item{tstep}{the time step to predict to (in days)}

\item{tpar}{generalised t-distribution parameters for ARGOS location classes. By 
default dat4jags uses the parameters estimated in Jonsen et al (2005) Ecology 86:2874-2880
but users may specify other ARGOS error parameter values via the \code{tpar} function.}
}
\value{
A list with components
\item{\code{id}}{the unique identifier for each dataset}
\item{\code{y}}{a 2 column matrix of the lon,lat observations}
\item{\code{itau2}}{a 2 column matrix of the ARGOS precision (1/scale) parameters}
\item{\code{nu}}{a 2 column matrix of the ARGOS df parameters}
\item{\code{idx}}{a vector of interpolation indices}
\item{\code{ws}}{a vector of interpolation weights}
\item{\code{ts}}{the times at which states are predicted (POSIXct,GMT)}
\item{\code{obs}}{the input observed data frame}
\item{\code{tstep}}{the time step specified in the \code{fitSSM} call}
}
\description{
Format track data for filtering
}
\details{
This is an internal function used by \code{fit_ssm} to format track
data for JAGS.

The input track is given as a dataframe where each row is an
observed location and columns
\describe{
\item{'id'}{individual animal identifier,}
\item{'date'}{observation time (POSIXct,GMT),}
\item{'lc'}{ARGOS location class,}
\item{'lon'}{observed longitude,}
\item{'lat'}{observed latitude.}
}
Location classes can include Z, F, and G; where the latter two 
are used to designate fixed (known) locations (e.g. GPS locations)
and "generic" locations (e.g. geolocation data) where the user 
supplies the error standard deviations, either via the 
\code{tpar} function or as two extra columns in the input data.

From this \code{dat4jags} calculates interpolation indices \code{idx} and
weights \code{ws} such that if \code{x} is the matrix of predicted
states, the fitted locations are \code{ws*x[idx+1,] +
(1-ws)*x[idx+2,]}.
}
\references{
Jonsen ID, Mills Flemming J, Myers RA (2005) Robust state-space modeling of
animal movement data. Ecology 86:2874-2880 (Appendix A)
}
