% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bscui.R
\name{bscui-shiny}
\alias{bscui-shiny}
\alias{bscuiOutput}
\alias{renderBscui}
\title{'shiny' bindings for bscui}
\usage{
bscuiOutput(outputId, width = "100\%", height = "400px")

renderBscui(expr, env = parent.frame(), quoted = FALSE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{Must be a valid CSS unit (like \code{'100\\\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{expr}{An expression that generates a bscui}

\item{env}{The environment in which to evaluate \code{expr}.}

\item{quoted}{Is \code{expr} a quoted expression (with \code{quote()})? This
is useful if you want to save an expression in a variable.}
}
\value{
An output or render function that enables the use of the widget
within 'shiny' applications.
}
\description{
Output and render functions for using bscui within 'shiny' applications.
}
\details{
The \code{\link[=bscuiProxy]{bscuiProxy()}} function can be used to allow user interface dynamic
updates.
}
\examples{
if(interactive()){
   from_shiny <- new.env()
   shiny::runApp(system.file(
      "examples", "shiny-anatomogram", package = "bscui"
   ))
   for(n in names(from_shiny)){
      bscui(from_shiny[[n]]) |> print()
   }
}
}
\seealso{
\code{\link[=bscuiProxy]{bscuiProxy()}}
}
