% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bscui.R
\name{bscui}
\alias{bscui}
\title{Build SVG Custom User Interface}
\usage{
bscui(
  svg_txt,
  sanitize_attributes = TRUE,
  width = NULL,
  height = NULL,
  elementId = NULL
)
}
\arguments{
\item{svg_txt}{a character with SVG code}

\item{sanitize_attributes}{logical indicating if
'<' and '>' characters in element attributes must be replaced by text}

\item{width, height}{widget width: must be a valid CSS unit (like \code{'100\\\%'},
\code{'400px'}, \code{'auto'}) or a number, which will be coerced to a
string and have \code{'px'} appended.}

\item{elementId}{hmtl identifier of the widget}
}
\value{
An \code{htmlwidget} object
}
\description{
Build SVG Custom User Interface
}
\examples{
##################################@
### Preparing data ----

library(bscui)
library(xml2)
library(readr)
library(dplyr)

svg <- xml2::read_xml(system.file(
   "examples", "Animal_cells.svg.gz",
   package="bscui"
))
info <- readr::read_tsv(system.file(
   "examples", "uniprot_cellular_locations.txt.gz",
   package="bscui"
), col_types=strrep("c", 6)) |>
   mutate(id = sub("-", "", `Subcellular location ID`))

##################################@
### Building the figure ----

figure <- bscui(svg) |>
   set_bscui_ui_elements(
      info |>
         mutate(
            ui_type = "selectable",
            title = Name
         ) |>
         select(id, ui_type, title)
   ) |>
   set_bscui_styles(
      info |>
         filter(Name == "Cytosol") |>
         mutate(fill = "#FF7F7F") |>
         select(id, fill)
   ) |>
   set_bscui_attributes(
      info |>
         filter(Name == "Cytoskeleton") |>
         mutate(display = "none") |>
         select(id, display)
   ) |>
   set_bscui_selection("SL0188") |>
   set_bscui_options(zoom_min=1, clip=TRUE)
figure

##################################@
### Saving the figure ----

if(interactive()){
   ## Temporary directory to save example file
   tdir <- tempdir()

   ## Interactive html file
   f_path <- file.path(tdir, "figure.html")
   figure |> htmlwidgets::saveWidget(file=f_path)
   cat(f_path)

   ## PNG image
   f_path <- file.path(tdir, "figure.png")
   figure |>
      set_bscui_options(show_menu = FALSE) |>
      export_bscui_to_image(file=f_path, zoom=2)
   cat(f_path)
}
}
