% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bs-icon.R
\name{bs_icon}
\alias{bs_icon}
\title{Use Bootstrap icons (as inline SVG)}
\usage{
bs_icon(
  name,
  size = "1em",
  class = NULL,
  title = NULL,
  a11y = c("deco", "sem", "none"),
  ...
)
}
\arguments{
\item{name}{The name of the Bootstrap icon. Whitespace is replaced with \code{-}
(that way, \code{"arrow up"} can be used to refer to the "actual name" of
\code{"arrow-up"}). For a searchable list of names, see \url{https://icons.getbootstrap.com/}}

\item{size}{Any valid CSS unit defining both the height and width of the
icon.}

\item{class}{Additional CSS classes to add to the \verb{<svg>} element. Consider
providing Bootstrap 4+ utility classes (e.g., \code{text-success}) here to
stylize the icon (but also note that those utility classes will only work
when Bootstrap 4+ is on the page).}

\item{title}{An option for populating the SVG \code{'title'} attribute, which
provides on-hover text for the icon. By default, no title text is given to
the icon. If \code{a11y == "semantic"} then title text will be automatically
given to the rendered icon, however, providing text here will override
that.}

\item{a11y}{Cases that distinguish the role of the icon and inform which
accessibility attributes to be used. Icons can either be \code{"deco"}
(decorative, the default case) or \code{"sem"} (semantic). Using \code{"none"} will
result in no accessibility features for the icon.}

\item{...}{additional CSS properties (e.g., \code{margin}, \code{position}, etc.)
placed on the \verb{<svg>} tag.}
}
\value{
An \code{\link[htmltools:HTML]{htmltools::HTML()}} string containing the SVG icon.
}
\description{
Use Bootstrap icons (as inline SVG)
}
\examples{

up <- bs_icon("arrow-up-circle", size = "9em", class = "text-success")
up_fill <- bs_icon("arrow-up-circle-fill", size = "9em", class = "text-success")

# utility class will only apply with a modern version of Bootstrap
if (interactive() && requireNamespace('bslib')) {
  bslib::page_fluid(up, up_fill)
}

}
