% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feed_feed.R
\name{bs_get_feed}
\alias{bs_get_feed}
\title{Build feed from user's feed generator}
\usage{
bs_get_feed(
  feed,
  user = get_bluesky_user(),
  pass = get_bluesky_pass(),
  auth = bs_auth(user, pass)
)
}
\arguments{
\item{feed}{Character, length 1. Feed to get.}

\item{user}{Character. User name to log in with. Defaults to \code{get_bluesky_user()}.}

\item{pass}{Character. App password to log in with. Defaults to \code{get_bluesky_pass()}.}

\item{auth}{Authentication information. Defaults to \code{bs_auth(user, pass)}.}
}
\value{
a tibble of posts
}
\description{
Build feed from user's feed generator
}
\section{Lexicon references}{

\href{https://github.com/bluesky-social/atproto/blob/main/lexicons/app/bsky/feed/getFeed.json}{feed/getFeed.json (2023-10-01)}
}

\section{Function introduced}{

\code{v0.0.1} (2023-10-01)
}

\examples{
\dontshow{if (has_bluesky_pass() && has_bluesky_user()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
bs_get_feed('at://did:plc:z72i7hdynmk6r22z27h6tvur/app.bsky.feed.generator/bsky-team')
\dontshow{\}) # examplesIf}
}
\concept{feed}
