% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card_body}
\alias{card_body}
\alias{card_title}
\alias{card_header}
\alias{card_footer}
\alias{card_image}
\alias{as.card_item}
\alias{is.card_item}
\title{Card items}
\usage{
card_body(
  ...,
  fillable = TRUE,
  min_height = NULL,
  max_height = NULL,
  max_height_full_screen = max_height,
  height = NULL,
  padding = NULL,
  gap = NULL,
  fill = TRUE,
  class = NULL
)

card_title(..., container = htmltools::h5)

card_header(..., class = NULL, container = htmltools::div)

card_footer(..., class = NULL)

card_image(
  file,
  ...,
  href = NULL,
  border_radius = c("top", "bottom", "all", "none"),
  mime_type = NULL,
  class = NULL,
  height = NULL,
  fill = TRUE,
  width = NULL,
  container = card_body
)

as.card_item(x)

is.card_item(x)
}
\arguments{
\item{...}{Unnamed arguments can be any valid child of an \link[htmltools:builder]{htmltools tag}. Named arguments become HTML attributes on returned
UI element.}

\item{fillable}{Whether or not the card item should be a fillable (i.e.
flexbox) container.}

\item{min_height, max_height, max_height_full_screen}{Any valid \link[htmltools:validateCssUnit]{CSS length unit}.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}). Doesn't apply when a card is made \code{full_screen}
(in this case, consider setting a \code{height} in \code{\link[=card_body]{card_body()}}).}

\item{padding}{Padding to use for the body. This can be a numeric vector
(which will be interpreted as pixels) or a character vector with valid CSS
lengths. The length can be between one and four. If one, then that value
will be used for all four sides. If two, then the first value will be used
for the top and bottom, while the second value will be used for left and
right. If three, then the first will be used for top, the second will be
left and right, and the third will be bottom. If four, then the values will
be interpreted as top, right, bottom, and left respectively.}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}. This argument is only applicable when \code{fillable = TRUE}}

\item{fill}{Whether to allow this element to grow/shrink to fit its \code{card()}
container.}

\item{class}{Additional CSS classes for the returned UI element.}

\item{container}{a function to generate an HTML element to contain the image.}

\item{file}{a file path pointing an image. The image will be base64 encoded
and provided to the \code{src} attribute of the \verb{<img>}. Alternatively, you may
set this value to \code{NULL} and provide the \code{src} yourself.}

\item{href}{an optional URL to link to.}

\item{border_radius}{where to apply \code{border-radius} on the image.}

\item{mime_type}{the mime type of the \code{file}.}

\item{width}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g., \code{width="100\%"}).}

\item{x}{an object to test (or coerce to) a card item.}
}
\value{
An \code{\link[htmltools:builder]{htmltools::div()}} tag.
}
\description{
Components designed to be provided as direct children of a \code{\link[=card]{card()}}. For a
general overview of the \code{\link[=card]{card()}} API, see \href{https://rstudio.github.io/bslib/articles/cards.html}{this article}.
}
\section{Functions}{
\itemize{
\item \code{card_body()}: A general container for the "main content" of a \code{\link[=card]{card()}}.

\item \code{card_title()}: Similar to \code{card_header()} but without the border and background color.

\item \code{card_header()}: A header (with border and background color) for the \code{card()}. Typically appears before a \code{card_body()}.

\item \code{card_footer()}: A header (with border and background color) for the \code{card()}. Typically appears after a \code{card_body()}.

\item \code{card_image()}: Include static (i.e., pre-generated) images.

\item \code{as.card_item()}: Mark an object as a card item. This will prevent the
\code{\link[=card]{card()}} from putting the object inside a \code{wrapper} (i.e., a
\code{card_body()}).

}}
\seealso{
\code{\link[=card]{card()}} for creating a card component.

\code{\link[=navset_card_tab]{navset_card_tab()}} for cards with multiple tabs.

\code{\link[=layout_column_wrap]{layout_column_wrap()}} for laying out multiple cards (or multiple
columns inside a card).
}
