# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Basis matrix for B-spline of order 0 (step function) and higher
#'
#' This function is analogous but not equivalent to \code{splines:bs()} and \code{splines2::bSpline()}.
#' It is also several times faster.
#'
#' @param x Numeric vector, abscissa points
#' @param xk Numeric vector, knots
#' @param n Integer scalar, polynomial order (3 by default)
#' @return Numeric matrix, each column correspond to a B-spline calculated on x
#' @details
#'   For n==0, step function is defined as constant on each interval
#'   \code{[xk[i]; xk[i+1][}, i.e. closed on the left and open on the right
#'   except for the last interval which is closed on the right too.
#' @seealso {splines::bs()}, {splines2::bSpline()}
#' @examples
#'   x=seq(0, 5, length.out=101)
#'   # cubic basis matrix
#'   n=3
#'   m=bsc(x, xk=c(rep(0, n+1), 1:4, rep(5, n+1)), n=n)
#'   matplot(x, m, t="l")
#'   stopifnot(all.equal.numeric(c(m), c(splines::bs(x, knots = 1:4, degree = n, intercept = TRUE))))
#' @importFrom Rcpp evalCpp
#' @export
bsc <- function(x, xk, n = 3L) {
    .Call(`_bspline_bsc`, x, xk, n)
}

