% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specify_bsvar.R
\name{specify_identification_bsvars}
\alias{specify_identification_bsvars}
\title{R6 Class Representing IdentificationBSVARs}
\description{
The class IdentificationBSVARs presents the identifying restrictions for the bsvar models.
}
\examples{
specify_identification_bsvars$new(N = 3) # recursive specification for a 3-variable system

B = matrix(c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE), 3, 3); B
specify_identification_bsvars$new(N = 3, B = B) # an alternative identification pattern


## ------------------------------------------------
## Method `specify_identification_bsvars$get_identification`
## ------------------------------------------------

B    = matrix(c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE), 3, 3); B
spec = specify_identification_bsvars$new(N = 3, B = B)
spec$get_identification()


## ------------------------------------------------
## Method `specify_identification_bsvars$set_identification`
## ------------------------------------------------

spec = specify_identification_bsvars$new(N = 3) # specify a model with the default option
B    = matrix(c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE), 3, 3); B
spec$set_identification(N = 3, B = B)  # modify an existing specification
spec$get_identification()              # check the outcome
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{VB}}{a list of \code{N} matrices determining the unrestricted elements of matrix \eqn{B}.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-IdentificationBSVARs-new}{\code{specify_identification_bsvars$new()}}
\item \href{#method-IdentificationBSVARs-get_identification}{\code{specify_identification_bsvars$get_identification()}}
\item \href{#method-IdentificationBSVARs-set_identification}{\code{specify_identification_bsvars$set_identification()}}
\item \href{#method-IdentificationBSVARs-clone}{\code{specify_identification_bsvars$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdentificationBSVARs-new"></a>}}
\if{latex}{\out{\hypertarget{method-IdentificationBSVARs-new}{}}}
\subsection{Method \code{new()}}{
Create new identifying restrictions IdentificationBSVARs.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_identification_bsvars$new(N, B)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{B}}{a logical \code{NxN} matrix containing value \code{TRUE} for the elements of the structural matrix \eqn{B} to be estimated and value \code{FALSE} for exclusion restrictions to be set to zero.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Identifying restrictions IdentificationBSVARs.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdentificationBSVARs-get_identification"></a>}}
\if{latex}{\out{\hypertarget{method-IdentificationBSVARs-get_identification}{}}}
\subsection{Method \code{get_identification()}}{
Returns the elements of the identification pattern IdentificationBSVARs as a \code{list}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_identification_bsvars$get_identification()}\if{html}{\out{</div>}}
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{B    = matrix(c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE), 3, 3); B
spec = specify_identification_bsvars$new(N = 3, B = B)
spec$get_identification()

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdentificationBSVARs-set_identification"></a>}}
\if{latex}{\out{\hypertarget{method-IdentificationBSVARs-set_identification}{}}}
\subsection{Method \code{set_identification()}}{
Set new starting values StartingValuesBSVAR.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_identification_bsvars$set_identification(N, B)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{N}}{a positive integer - the number of dependent variables in the model.}

\item{\code{B}}{a logical \code{NxN} matrix containing value \code{TRUE} for the elements of the structural matrix \eqn{B} to be estimated and value \code{FALSE} for exclusion restrictions to be set to zero.}
}
\if{html}{\out{</div>}}
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{spec = specify_identification_bsvars$new(N = 3) # specify a model with the default option
B    = matrix(c(TRUE,TRUE,TRUE,FALSE,FALSE,TRUE,FALSE,TRUE,TRUE), 3, 3); B
spec$set_identification(N = 3, B = B)  # modify an existing specification
spec$get_identification()              # check the outcome
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-IdentificationBSVARs-clone"></a>}}
\if{latex}{\out{\hypertarget{method-IdentificationBSVARs-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{specify_identification_bsvars$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
